/*
 * Decompiled with CFR 0.152.
 */
package io.github.md2java.lock.provider;

import io.github.md2java.lock.annotation.ClusterLock;
import io.github.md2java.lock.model.LockInfo;
import io.github.md2java.lock.provider.LockProvider;
import io.github.md2java.lock.util.BeanScannerUtil;
import io.github.md2java.lock.util.DBUtil;
import io.github.md2java.lock.util.MemoryUtil;
import io.github.md2java.lock.util.NodeUtil;
import io.github.md2java.lock.util.QueryList;
import java.sql.Timestamp;
import java.time.LocalDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.sql.DataSource;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;

public class JdbcLockProvider
implements LockProvider {
    private static final Logger log = LoggerFactory.getLogger(JdbcLockProvider.class);
    private final DataSource dataSource;
    private String node;
    private JdbcTemplate jdbcTemplate;
    private Map<String, ClusterLock> configuredLocks;
    private String driverClassName;

    @Override
    public void init() {
        this.node = NodeUtil.hostId();
        this.jdbcTemplate = new JdbcTemplate(this.dataSource);
        this.driverClassName = DBUtil.getDriverClassName(this.dataSource);
        this.configuredLocks = BeanScannerUtil.configuredLocks();
        this.createTableIfNotExist("CLUSTERLOCKINFO");
        Set<String> names = this.configuredLocks.keySet();
        names.forEach(s -> this.monitorLock((String)s));
    }

    private void createTableIfNotExist(String locktablename) {
        if (BooleanUtils.isFalse((Boolean)this.doesTableExist(locktablename))) {
            QueryList[] values = QueryList.values();
            String createTableQuery = null;
            for (QueryList queryList : values) {
                boolean contains = StringUtils.contains((CharSequence)this.driverClassName.toUpperCase(), (CharSequence)queryList.name());
                if (!contains) continue;
                createTableQuery = queryList.query();
                break;
            }
            if (StringUtils.isBlank(createTableQuery)) {
                throw new RuntimeException("something went wrong to find create table query.");
            }
            try {
                this.jdbcTemplate.execute(createTableQuery);
            }
            catch (Exception e) {
                log.error("something went wrong to to execute query: {} => {} ", createTableQuery, (Object)e.toString());
                throw e;
            }
        }
    }

    @Override
    public Map<String, Object> updateLock(String lockName) {
        LockInfo lockInfo = MemoryUtil.getLockInfo(lockName);
        Map<String, Object> updateLastRun = this.updateLastRun(lockName, lockInfo);
        return updateLastRun;
    }

    @Override
    public Map<String, Object> monitorLock(String lockName) {
        log.debug("monitor scheduler started...");
        Map<String, Object> lockInfo = this.findLockInfo(lockName);
        MemoryUtil.updateLockInfo(lockName, lockInfo);
        if (this.isNeedToSwitchNode(lockInfo)) {
            this.switchNode(lockName);
            lockInfo = this.findLockInfo(lockName);
            MemoryUtil.updateLockInfo(lockName, lockInfo);
        }
        return lockInfo;
    }

    private void switchNode(String lockName) {
        LockInfo updateLock = LockInfo.builder().activeNode(this.node).lockname(lockName).lastrun(new Date()).build();
        Map<String, Object> lockDetails = this.updateSwitchNode(lockName, updateLock);
        if (Objects.nonNull(lockDetails)) {
            log.debug("lock switched node to : {} ", (Object)updateLock.getActiveNode());
        }
    }

    private boolean isNeedToSwitchNode(Map<String, Object> lockInfo) {
        LockInfo lockInfoModel = MemoryUtil.getLockInfo(String.valueOf(lockInfo.get("name")));
        Date lastrun = lockInfoModel.getLastrun();
        Date now = new Date();
        long updateAt = MemoryUtil.getEnableClusterLock().updateAt();
        return now.getTime() - lastrun.getTime() > updateAt + 100L;
    }

    private boolean doesTableExist(String tableName) {
        try {
            this.jdbcTemplate.queryForObject("SELECT 1 FROM " + tableName + " WHERE 1 = 0", Integer.class);
            return true;
        }
        catch (EmptyResultDataAccessException e) {
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private Map<String, Object> findLockInfo(String lockname) {
        Map mapData = null;
        try {
            mapData = this.jdbcTemplate.queryForMap("SELECT * FROM CLUSTERLOCKINFO WHERE name =? ", new Object[]{lockname});
            return mapData;
        }
        catch (EmptyResultDataAccessException e) {
            this.jdbcTemplate.update(String.format("INSERT INTO %s  (name,lastrun,activenode) VALUES(?,?,?)", "CLUSTERLOCKINFO"), new Object[]{lockname, Timestamp.valueOf(LocalDateTime.now()), this.node});
            mapData = this.jdbcTemplate.queryForMap("SELECT * FROM CLUSTERLOCKINFO WHERE name = ?", new Object[]{lockname});
            return mapData;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Map<String, Object> updateLastRun(String lockname, LockInfo lockInfo) {
        Map<String, Object> mapData = null;
        try {
            int update = this.jdbcTemplate.update(String.format("UPDATE %s set lastrun=? where name=? and activenode=?", "CLUSTERLOCKINFO"), new Object[]{lockInfo.getLastrun(), lockname, lockInfo.getActiveNode()});
            if (update > 0) {
                mapData = this.buildResponse(lockname, lockInfo.getActiveNode(), lockInfo.getLastrun());
            }
            return mapData;
        }
        catch (Exception e) {
            return null;
        }
    }

    private Map<String, Object> updateSwitchNode(String lockname, LockInfo lockInfo) {
        Map<String, Object> mapData = null;
        try {
            int update = this.jdbcTemplate.update(String.format("UPDATE %s set lastrun=? ,activenode=? where name=? ", "CLUSTERLOCKINFO"), new Object[]{lockInfo.getLastrun(), lockInfo.getActiveNode(), lockname});
            if (update > 0) {
                mapData = this.buildResponse(lockname, lockInfo.getActiveNode(), lockInfo.getLastrun());
            }
            return mapData;
        }
        catch (Exception e) {
            log.error("something went wrong: ", (Throwable)e);
            return null;
        }
    }

    private Map<String, Object> buildResponse(String lockname, String node, Date timestamp) {
        HashMap<String, Object> mapData = new HashMap<String, Object>();
        mapData.put("name", lockname);
        mapData.put("lastrun", timestamp);
        mapData.put("activenode", node);
        return mapData;
    }

    @Override
    public void monitorAll() {
        Set<String> names = this.configuredLocks.keySet();
        names.forEach(s -> {
            LockInfo lockInfo = MemoryUtil.getLockInfo(s);
            if (Objects.nonNull(lockInfo) && StringUtils.equalsIgnoreCase((CharSequence)this.node, (CharSequence)lockInfo.getActiveNode())) {
                log.debug("skipped because activenode is the current node");
                return;
            }
            this.monitorLock((String)s);
        });
    }

    public JdbcLockProvider(DataSource dataSource) {
        this.dataSource = dataSource;
    }
}

