/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import io.github.microcks.client.JSON;
import io.github.microcks.client.model.AbstractOpenApiSchema;
import io.github.microcks.client.model.RequestResponsePair;
import io.github.microcks.client.model.UnidirectionalEvent;
import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Level;
import java.util.logging.Logger;

@JsonDeserialize(using=ExchangeDeserializer.class)
@JsonSerialize(using=ExchangeSerializer.class)
public class Exchange
extends AbstractOpenApiSchema {
    private static final Logger log = Logger.getLogger(Exchange.class.getName());
    public static final Map<String, Class<?>> schemas = new HashMap();

    public Exchange() {
        super("oneOf", Boolean.FALSE);
    }

    public Exchange(RequestResponsePair o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    public Exchange(UnidirectionalEvent o) {
        super("oneOf", Boolean.FALSE);
        this.setActualInstance(o);
    }

    @Override
    public Map<String, Class<?>> getSchemas() {
        return schemas;
    }

    @Override
    public void setActualInstance(Object instance) {
        if (JSON.isInstanceOf(RequestResponsePair.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        if (JSON.isInstanceOf(UnidirectionalEvent.class, instance, new HashSet())) {
            super.setActualInstance(instance);
            return;
        }
        throw new RuntimeException("Invalid instance type. Must be RequestResponsePair, UnidirectionalEvent");
    }

    @Override
    public Object getActualInstance() {
        return super.getActualInstance();
    }

    public RequestResponsePair getRequestResponsePair() throws ClassCastException {
        return (RequestResponsePair)super.getActualInstance();
    }

    public UnidirectionalEvent getUnidirectionalEvent() throws ClassCastException {
        return (UnidirectionalEvent)super.getActualInstance();
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getActualInstance() instanceof RequestResponsePair) {
            if (this.getActualInstance() != null) {
                joiner.add(((RequestResponsePair)this.getActualInstance()).toUrlQueryString((String)prefix + "one_of_0" + suffix));
            }
            return joiner.toString();
        }
        if (this.getActualInstance() instanceof UnidirectionalEvent) {
            if (this.getActualInstance() != null) {
                joiner.add(((UnidirectionalEvent)this.getActualInstance()).toUrlQueryString((String)prefix + "one_of_1" + suffix));
            }
            return joiner.toString();
        }
        return null;
    }

    static {
        schemas.put("RequestResponsePair", RequestResponsePair.class);
        schemas.put("UnidirectionalEvent", UnidirectionalEvent.class);
        JSON.registerDescendants(Exchange.class, Collections.unmodifiableMap(schemas));
        HashMap mappings = new HashMap();
        mappings.put("reqRespPair", RequestResponsePair.class);
        mappings.put("unidirEvent", UnidirectionalEvent.class);
        mappings.put("RequestResponsePair", RequestResponsePair.class);
        mappings.put("UnidirectionalEvent", UnidirectionalEvent.class);
        mappings.put("Exchange", Exchange.class);
        JSON.registerDiscriminator(Exchange.class, "type", mappings);
    }

    public static class ExchangeDeserializer
    extends StdDeserializer<Exchange> {
        public ExchangeDeserializer() {
            this(Exchange.class);
        }

        public ExchangeDeserializer(Class<?> vc) {
            super(vc);
        }

        public Exchange deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonNode tree = (JsonNode)jp.readValueAsTree();
            Object deserialized = null;
            boolean typeCoercion = ctxt.isEnabled(MapperFeature.ALLOW_COERCION_OF_SCALARS);
            int match = 0;
            JsonToken token = tree.traverse(jp.getCodec()).nextToken();
            try {
                boolean attemptParsing = true;
                if ((RequestResponsePair.class.equals(Integer.class) || RequestResponsePair.class.equals(Long.class) || RequestResponsePair.class.equals(Float.class) || RequestResponsePair.class.equals(Double.class) || RequestResponsePair.class.equals(Boolean.class) || RequestResponsePair.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (RequestResponsePair.class.equals(Integer.class) || RequestResponsePair.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= (RequestResponsePair.class.equals(Float.class) || RequestResponsePair.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT;
                    attemptParsing |= RequestResponsePair.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= RequestResponsePair.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    deserialized = tree.traverse(jp.getCodec()).readValueAs(RequestResponsePair.class);
                    ++match;
                    log.log(Level.FINER, "Input data matches schema 'RequestResponsePair'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'RequestResponsePair'", e);
            }
            try {
                boolean attemptParsing = true;
                if ((UnidirectionalEvent.class.equals(Integer.class) || UnidirectionalEvent.class.equals(Long.class) || UnidirectionalEvent.class.equals(Float.class) || UnidirectionalEvent.class.equals(Double.class) || UnidirectionalEvent.class.equals(Boolean.class) || UnidirectionalEvent.class.equals(String.class)) && !(attemptParsing = typeCoercion)) {
                    attemptParsing |= (UnidirectionalEvent.class.equals(Integer.class) || UnidirectionalEvent.class.equals(Long.class)) && token == JsonToken.VALUE_NUMBER_INT;
                    attemptParsing |= (UnidirectionalEvent.class.equals(Float.class) || UnidirectionalEvent.class.equals(Double.class)) && token == JsonToken.VALUE_NUMBER_FLOAT;
                    attemptParsing |= UnidirectionalEvent.class.equals(Boolean.class) && (token == JsonToken.VALUE_FALSE || token == JsonToken.VALUE_TRUE);
                    attemptParsing |= UnidirectionalEvent.class.equals(String.class) && token == JsonToken.VALUE_STRING;
                }
                if (attemptParsing) {
                    deserialized = tree.traverse(jp.getCodec()).readValueAs(UnidirectionalEvent.class);
                    ++match;
                    log.log(Level.FINER, "Input data matches schema 'UnidirectionalEvent'");
                }
            }
            catch (Exception e) {
                log.log(Level.FINER, "Input data does not match schema 'UnidirectionalEvent'", e);
            }
            if (match == 1) {
                Exchange ret = new Exchange();
                ret.setActualInstance(deserialized);
                return ret;
            }
            throw new IOException(String.format("Failed deserialization for Exchange: %d classes match result, expected 1", match));
        }

        public Exchange getNullValue(DeserializationContext ctxt) throws JsonMappingException {
            throw new JsonMappingException((Closeable)ctxt.getParser(), "Exchange cannot be null");
        }
    }

    public static class ExchangeSerializer
    extends StdSerializer<Exchange> {
        public ExchangeSerializer(Class<Exchange> t) {
            super(t);
        }

        public ExchangeSerializer() {
            this(null);
        }

        public void serialize(Exchange value, JsonGenerator jgen, SerializerProvider provider) throws IOException, JsonProcessingException {
            jgen.writeObject(value.getActualInstance());
        }
    }
}

