/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import io.github.microcks.client.ApiClient;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"realm", "auth-server-url", "public-client", "ssl-required", "resource", "enabled"})
public class KeycloakConfig {
    public static final String JSON_PROPERTY_REALM = "realm";
    private String realm;
    public static final String JSON_PROPERTY_AUTH_SERVER_URL = "auth-server-url";
    private String authServerUrl;
    public static final String JSON_PROPERTY_PUBLIC_CLIENT = "public-client";
    private Boolean publicClient;
    public static final String JSON_PROPERTY_SSL_REQUIRED = "ssl-required";
    private SslRequiredEnum sslRequired;
    public static final String JSON_PROPERTY_RESOURCE = "resource";
    private String resource;
    public static final String JSON_PROPERTY_ENABLED = "enabled";
    private Boolean enabled;

    public KeycloakConfig realm(String realm) {
        this.realm = realm;
        return this;
    }

    @Nonnull
    @JsonProperty(value="realm")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getRealm() {
        return this.realm;
    }

    @JsonProperty(value="realm")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setRealm(String realm) {
        this.realm = realm;
    }

    public KeycloakConfig authServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
        return this;
    }

    @Nonnull
    @JsonProperty(value="auth-server-url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getAuthServerUrl() {
        return this.authServerUrl;
    }

    @JsonProperty(value="auth-server-url")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setAuthServerUrl(String authServerUrl) {
        this.authServerUrl = authServerUrl;
    }

    public KeycloakConfig publicClient(Boolean publicClient) {
        this.publicClient = publicClient;
        return this;
    }

    @Nonnull
    @JsonProperty(value="public-client")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getPublicClient() {
        return this.publicClient;
    }

    @JsonProperty(value="public-client")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setPublicClient(Boolean publicClient) {
        this.publicClient = publicClient;
    }

    public KeycloakConfig sslRequired(SslRequiredEnum sslRequired) {
        this.sslRequired = sslRequired;
        return this;
    }

    @Nonnull
    @JsonProperty(value="ssl-required")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public SslRequiredEnum getSslRequired() {
        return this.sslRequired;
    }

    @JsonProperty(value="ssl-required")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setSslRequired(SslRequiredEnum sslRequired) {
        this.sslRequired = sslRequired;
    }

    public KeycloakConfig resource(String resource) {
        this.resource = resource;
        return this;
    }

    @Nonnull
    @JsonProperty(value="resource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public String getResource() {
        return this.resource;
    }

    @JsonProperty(value="resource")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setResource(String resource) {
        this.resource = resource;
    }

    public KeycloakConfig enabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    @Nonnull
    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Boolean getEnabled() {
        return this.enabled;
    }

    @JsonProperty(value="enabled")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setEnabled(Boolean enabled) {
        this.enabled = enabled;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeycloakConfig keycloakConfig = (KeycloakConfig)o;
        return Objects.equals(this.realm, keycloakConfig.realm) && Objects.equals(this.authServerUrl, keycloakConfig.authServerUrl) && Objects.equals(this.publicClient, keycloakConfig.publicClient) && Objects.equals((Object)this.sslRequired, (Object)keycloakConfig.sslRequired) && Objects.equals(this.resource, keycloakConfig.resource) && Objects.equals(this.enabled, keycloakConfig.enabled);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.realm, this.authServerUrl, this.publicClient, this.sslRequired, this.resource, this.enabled});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class KeycloakConfig {\n");
        sb.append("    realm: ").append(this.toIndentedString(this.realm)).append("\n");
        sb.append("    authServerUrl: ").append(this.toIndentedString(this.authServerUrl)).append("\n");
        sb.append("    publicClient: ").append(this.toIndentedString(this.publicClient)).append("\n");
        sb.append("    sslRequired: ").append(this.toIndentedString((Object)this.sslRequired)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    enabled: ").append(this.toIndentedString(this.enabled)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getRealm() != null) {
            joiner.add(String.format("%srealm%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getRealm()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getAuthServerUrl() != null) {
            joiner.add(String.format("%sauth-server-url%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getAuthServerUrl()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getPublicClient() != null) {
            joiner.add(String.format("%spublic-client%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getPublicClient()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getSslRequired() != null) {
            joiner.add(String.format("%sssl-required%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString((Object)this.getSslRequired()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getResource() != null) {
            joiner.add(String.format("%sresource%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getResource()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        if (this.getEnabled() != null) {
            joiner.add(String.format("%senabled%s=%s", prefix, suffix, URLEncoder.encode(ApiClient.valueToString(this.getEnabled()), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
        }
        return joiner.toString();
    }

    public static enum SslRequiredEnum {
        NONE("none"),
        EXTERNAL("external");

        private String value;

        private SslRequiredEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static SslRequiredEnum fromValue(String value) {
            for (SslRequiredEnum b : SslRequiredEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }
    }
}

