/*
 * Decompiled with CFR 0.152.
 */
package io.github.microcks.client.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.github.microcks.client.ApiClient;
import io.github.microcks.client.model.Exchange;
import io.github.microcks.client.model.Service;
import jakarta.annotation.Nonnull;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.StringJoiner;

@JsonPropertyOrder(value={"service", "messagesMap"})
public class ServiceView {
    public static final String JSON_PROPERTY_SERVICE = "service";
    private Service service;
    public static final String JSON_PROPERTY_MESSAGES_MAP = "messagesMap";
    private Map<String, List<Exchange>> messagesMap = new HashMap<String, List<Exchange>>();

    public ServiceView service(Service service) {
        this.service = service;
        return this;
    }

    @Nonnull
    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Service getService() {
        return this.service;
    }

    @JsonProperty(value="service")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setService(Service service) {
        this.service = service;
    }

    public ServiceView messagesMap(Map<String, List<Exchange>> messagesMap) {
        this.messagesMap = messagesMap;
        return this;
    }

    public ServiceView putMessagesMapItem(String key, List<Exchange> messagesMapItem) {
        if (this.messagesMap == null) {
            this.messagesMap = new HashMap<String, List<Exchange>>();
        }
        this.messagesMap.put(key, messagesMapItem);
        return this;
    }

    @Nonnull
    @JsonProperty(value="messagesMap")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public Map<String, List<Exchange>> getMessagesMap() {
        return this.messagesMap;
    }

    @JsonProperty(value="messagesMap")
    @JsonInclude(value=JsonInclude.Include.ALWAYS)
    public void setMessagesMap(Map<String, List<Exchange>> messagesMap) {
        this.messagesMap = messagesMap;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceView serviceView = (ServiceView)o;
        return Objects.equals(this.service, serviceView.service) && Objects.equals(this.messagesMap, serviceView.messagesMap);
    }

    public int hashCode() {
        return Objects.hash(this.service, this.messagesMap);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ServiceView {\n");
        sb.append("    service: ").append(this.toIndentedString(this.service)).append("\n");
        sb.append("    messagesMap: ").append(this.toIndentedString(this.messagesMap)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public String toUrlQueryString() {
        return this.toUrlQueryString(null);
    }

    public String toUrlQueryString(String prefix) {
        String suffix = "";
        String containerSuffix = "";
        String containerPrefix = "";
        if (prefix == null) {
            prefix = "";
        } else {
            prefix = (String)prefix + "[";
            suffix = "]";
            containerSuffix = "]";
            containerPrefix = "[";
        }
        StringJoiner joiner = new StringJoiner("&");
        if (this.getService() != null) {
            joiner.add(this.getService().toUrlQueryString((String)prefix + JSON_PROPERTY_SERVICE + suffix));
        }
        if (this.getMessagesMap() != null) {
            for (String _key : this.getMessagesMap().keySet()) {
                joiner.add(String.format("%smessagesMap%s%s=%s", prefix, suffix, "".equals(suffix) ? "" : String.format("%s%d%s", containerPrefix, _key, containerSuffix), this.getMessagesMap().get(_key), URLEncoder.encode(ApiClient.valueToString(this.getMessagesMap().get(_key)), StandardCharsets.UTF_8).replaceAll("\\+", "%20")));
            }
        }
        return joiner.toString();
    }
}

