/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.beans;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.lang.function.ThrowableSupplier;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.Assert;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Objects;

public class BeanProperty {
    @Nonnull
    private final String name;
    @Nullable
    private Object value;
    @Nonnull
    private final Class<?> beanClass;
    @Nonnull
    private final PropertyDescriptor descriptor;

    public BeanProperty(@Nonnull String name, @Nonnull Class<?> beanClass, @Nonnull PropertyDescriptor descriptor) {
        this.name = name;
        this.beanClass = beanClass;
        this.descriptor = descriptor;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Nullable
    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Nonnull
    public Class<?> getBeanClass() {
        return this.beanClass;
    }

    @Nonnull
    public PropertyDescriptor getDescriptor() {
        return this.descriptor;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof BeanProperty)) {
            return false;
        }
        BeanProperty that = (BeanProperty)o;
        if (!Objects.equals(this.name, that.name)) {
            return false;
        }
        if (!Objects.equals(this.value, that.value)) {
            return false;
        }
        if (!Objects.equals(this.beanClass, that.beanClass)) {
            return false;
        }
        return Objects.equals(this.descriptor, that.descriptor);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        result = 31 * result + this.beanClass.hashCode();
        result = 31 * result + this.descriptor.hashCode();
        return result;
    }

    public String toString() {
        String sb = "BeanProperty{name='" + this.name + '\'' + ", value=" + this.value + ", declaringClass=" + this.beanClass + ", descriptor=" + this.descriptor + '}';
        return sb;
    }

    public static BeanProperty of(@Nonnull Object bean, @Nonnull String propertyName) {
        Assert.assertNotNull(bean, "The 'bean' argument must not be null");
        Assert.assertNotNull((Object)propertyName, "The 'propertyName' argument must not be null");
        Class<?> beanClass = bean.getClass();
        return ThrowableSupplier.execute(() -> {
            PropertyDescriptor descriptor = new PropertyDescriptor(propertyName, beanClass);
            BeanProperty beanProperty = new BeanProperty(propertyName, beanClass, descriptor);
            Method getterMethod = descriptor.getReadMethod();
            Object propertyValue = MethodUtils.invokeMethod(bean, getterMethod, new Object[0]);
            beanProperty.value = propertyValue;
            return beanProperty;
        });
    }
}

