/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.classloading;

import io.microsphere.annotation.Nonnull;
import io.microsphere.classloading.URLClassPathHandle;
import io.microsphere.lang.Prioritized;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.net.URLUtils;
import io.microsphere.reflect.FieldUtils;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.ClassLoaderUtils;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;

public abstract class AbstractURLClassPathHandle
implements URLClassPathHandle,
Prioritized {
    public static final int DEFAULT_PRIORITY = -2147383649;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private Class<?> urlClassPathClass;
    private Field pathField;
    private Field urlsField;
    private Field loadersField;
    private Class<?> loaderClass;
    private Field baseField;
    private int priority;

    public AbstractURLClassPathHandle() {
        this.setPriority(-2147383649);
    }

    @Override
    public boolean supports() {
        return this.getUrlClassPathClass() != null;
    }

    @Override
    @Nonnull
    public URL[] getURLs(ClassLoader classLoader) {
        if (classLoader == null) {
            return URLUtils.EMPTY_URL_ARRAY;
        }
        Object ucp = FieldUtils.getFieldValue((Object)classLoader, this.findUcpField(classLoader));
        return ucp == null ? URLUtils.EMPTY_URL_ARRAY : (URL[])MethodUtils.invokeMethod(ucp, "getURLs", new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final boolean removeURL(ClassLoader classLoader, URL url) {
        if (classLoader == null || url == null) {
            return false;
        }
        this.initializeLoaders(classLoader);
        Object ucp = FieldUtils.getFieldValue((Object)classLoader, this.findUcpField(classLoader));
        Collection urls = (Collection)FieldUtils.getFieldValue(ucp, this.getUrlsField());
        Collection path = (Collection)FieldUtils.getFieldValue(ucp, this.getPathField());
        Collection loaders = (Collection)FieldUtils.getFieldValue(ucp, this.getLoadersField());
        String basePath = URLUtils.resolveBasePath(url);
        boolean removed = false;
        Collection collection = urls;
        synchronized (collection) {
            Iterator iterator = loaders.iterator();
            while (iterator.hasNext()) {
                Object loader = iterator.next();
                URL base = (URL)FieldUtils.getFieldValue(loader, this.getBaseField());
                String basePath_ = URLUtils.resolveBasePath(base);
                if (!Objects.equals(basePath_, basePath)) continue;
                if (this.logger.isTraceEnabled()) {
                    this.logger.trace("Remove the Class-Path URL\uff1a{}", url);
                }
                iterator.remove();
                urls.remove(url);
                path.remove(url);
                removed = true;
                break;
            }
        }
        return removed;
    }

    public final void setPriority(int priority) {
        this.priority = priority;
    }

    @Override
    public final int getPriority() {
        return this.priority;
    }

    protected final Class<?> getUrlClassPathClass() {
        Class<?> urlClassPathClass = this.urlClassPathClass;
        if (urlClassPathClass == null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            this.urlClassPathClass = urlClassPathClass = ClassLoaderUtils.resolveClass(this.getURLClassPathClassName(), classLoader);
        }
        return urlClassPathClass;
    }

    protected final Class<?> getLoaderClass() {
        Class<?> loaderClass = this.loaderClass;
        if (loaderClass == null) {
            ClassLoader classLoader = ClassLoader.getSystemClassLoader();
            this.loaderClass = loaderClass = ClassLoaderUtils.resolveClass(this.getURLClassPathClassName() + "$Loader", classLoader);
        }
        return loaderClass;
    }

    protected final Field findUcpField(ClassLoader classLoader) {
        return FieldUtils.findField(classLoader, "ucp");
    }

    protected final Field getPathField() {
        Field pathField = this.pathField;
        if (pathField == null) {
            this.pathField = pathField = FieldUtils.findField(this.getUrlClassPathClass(), "path");
        }
        return pathField;
    }

    protected final Field getUrlsField() {
        Field urlsField = this.urlsField;
        if (urlsField == null) {
            this.urlsField = urlsField = FieldUtils.findField(this.getUrlClassPathClass(), this.getUrlsFieldName());
        }
        return urlsField;
    }

    protected final Field getLoadersField() {
        Field loadersField = this.loadersField;
        if (loadersField == null) {
            this.loadersField = loadersField = FieldUtils.findField(this.getUrlClassPathClass(), "loaders");
        }
        return loadersField;
    }

    protected final Field getBaseField() {
        Field baseField = this.baseField;
        if (baseField == null) {
            this.baseField = baseField = FieldUtils.findField(this.getLoaderClass(), "base");
        }
        return baseField;
    }

    protected abstract String getURLClassPathClassName();

    protected abstract String getUrlsFieldName();
}

