/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.classloading;

import io.microsphere.classloading.AbstractArtifactResourceResolver;
import io.microsphere.classloading.Artifact;
import io.microsphere.net.URLUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.StringUtils;
import java.io.File;
import java.net.URL;

public class ArchiveFileArtifactResourceResolver
extends AbstractArtifactResourceResolver {
    public static final int DEFAULT_PRIORITY = 9;

    public ArchiveFileArtifactResourceResolver() {
        this(9);
    }

    public ArchiveFileArtifactResourceResolver(int priority) {
        super(priority);
    }

    public ArchiveFileArtifactResourceResolver(ClassLoader classLoader, int priority) {
        super(classLoader, priority);
    }

    @Override
    public Artifact resolve(URL resourceURL) {
        if (resourceURL == null) {
            return null;
        }
        File archiveFile = URLUtils.resolveArchiveFile(resourceURL);
        if (archiveFile == null || archiveFile.isDirectory()) {
            return null;
        }
        String archiveFileName = archiveFile.getName();
        String fileNameWithoutExtension = StringUtils.substringBeforeLast(archiveFileName, ".");
        String[] parts = StringUtils.split(fileNameWithoutExtension, "-");
        int length = ArrayUtils.length(parts);
        if (length < 1) {
            return null;
        }
        String artifactId = parts[0];
        String version = length > 1 ? parts[1] : null;
        return Artifact.create(artifactId, version, resourceURL);
    }
}

