/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.classloading;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import java.net.URL;
import java.util.Objects;
import java.util.function.Function;

public class Artifact {
    public static final String WILDCARD = "*";
    public static final String UNKNOWN = "?";
    @Nonnull
    private final String artifactId;
    @Nullable
    private final String version;
    @Nullable
    private final URL location;

    public Artifact(@Nonnull String artifactId, @Nullable String version, @Nullable URL location) {
        this.artifactId = artifactId;
        this.version = version;
        this.location = location;
    }

    public static Artifact create(@Nonnull String artifactId, @Nullable String version, @Nullable URL location) {
        return new Artifact(artifactId, version, location);
    }

    public static Artifact create(@Nonnull String artifactId, @Nullable String version) {
        return Artifact.create(artifactId, version, null);
    }

    public static Artifact create(@Nonnull String artifactId) {
        return Artifact.create(artifactId, UNKNOWN);
    }

    @Nonnull
    public String getArtifactId() {
        return this.artifactId;
    }

    @Nullable
    public String getVersion() {
        return this.version;
    }

    @Nullable
    public URL getLocation() {
        return this.location;
    }

    public boolean matches(Artifact artifact) {
        return this.matchesArtifactId(artifact) && this.matchesVersion(artifact);
    }

    protected boolean matchesArtifactId(Artifact artifact) {
        return this.matches(artifact, Artifact::getArtifactId);
    }

    protected boolean matchesVersion(Artifact artifact) {
        return this.matches(artifact, Artifact::getVersion);
    }

    protected boolean matches(Artifact artifact, Function<Artifact, String> getterFunction) {
        String configuredValue = getterFunction.apply(this);
        if (WILDCARD.equals(configuredValue)) {
            return true;
        }
        String value = getterFunction.apply(artifact);
        return configuredValue.equals(value);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Artifact)) {
            return false;
        }
        Artifact that = (Artifact)o;
        return Objects.equals(this.artifactId, that.artifactId) && Objects.equals(this.version, that.version) && Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hash(this.artifactId, this.version, this.location);
    }

    public String toString() {
        String sb = "Artifact{artifactId='" + this.artifactId + '\'' + ", version='" + this.version + '\'' + ", location='" + this.location + '\'' + '}';
        return sb;
    }
}

