/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.classloading;

import io.microsphere.annotation.Nullable;
import io.microsphere.classloading.Artifact;
import io.microsphere.classloading.ArtifactResourceResolver;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ClassPathUtils;
import io.microsphere.util.ServiceLoaderUtils;
import io.microsphere.util.SystemUtils;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ArtifactDetector {
    private static final Logger logger = LoggerFactory.getLogger(ArtifactDetector.class);
    private static final String JAVA_HOME_PATH = SystemUtils.JAVA_HOME;
    final ClassLoader classLoader;
    private final List<ArtifactResourceResolver> artifactResourceResolvers;

    public ArtifactDetector() {
        this(null);
    }

    public ArtifactDetector(@Nullable ClassLoader classLoader) {
        ClassLoader actualClassLoader = classLoader == null ? ClassLoaderUtils.getClassLoader(this.getClass()) : classLoader;
        this.artifactResourceResolvers = ServiceLoaderUtils.loadServicesList(ArtifactResourceResolver.class, actualClassLoader, true);
        this.classLoader = actualClassLoader;
        if (logger.isTraceEnabled()) {
            logger.trace("ClassLoader[argument : {} , actual : {}] , ArtifactResolver List : {}", classLoader, actualClassLoader, this.artifactResourceResolvers);
        }
    }

    public List<Artifact> detect() {
        return this.detect(true);
    }

    public List<Artifact> detect(boolean includedJdkLibraries) {
        Set<URL> classPathURLs = this.getClassPathURLs(includedJdkLibraries);
        return this.detect(classPathURLs);
    }

    protected List<Artifact> detect(Set<URL> classPathURLs) {
        if (CollectionUtils.isEmpty(classPathURLs)) {
            return Collections.emptyList();
        }
        LinkedList<Artifact> artifactList = new LinkedList<Artifact>();
        block0: for (URL resourceURL : classPathURLs) {
            for (ArtifactResourceResolver artifactResourceResolver : this.artifactResourceResolvers) {
                Artifact artifact = artifactResourceResolver.resolve(resourceURL);
                if (artifact == null) continue;
                artifactList.add(artifact);
                continue block0;
            }
        }
        return Collections.unmodifiableList(artifactList);
    }

    protected Set<URL> getClassPathURLs(boolean includedJdkLibraries) {
        Set<URL> urls = ClassLoaderUtils.findAllClassPathURLs(this.classLoader);
        LinkedHashSet<URL> classPathURLs = new LinkedHashSet<URL>(urls);
        if (!includedJdkLibraries) {
            this.removeJdkClassPathURLs(classPathURLs);
        }
        if (logger.isTraceEnabled()) {
            logger.trace("ClassLoader[{}] covers the URLs[expected: {}, actual: {}], class-path : {}", this.classLoader, urls.size(), classPathURLs.size(), classPathURLs);
        }
        return classPathURLs;
    }

    private void removeJdkClassPathURLs(Set<URL> classPathURLs) {
        Set<String> bootstrapClassPaths = ClassPathUtils.getBootstrapClassPaths();
        Iterator<URL> iterator = classPathURLs.iterator();
        while (iterator.hasNext()) {
            URL url = iterator.next();
            String path = url.getPath();
            if (!bootstrapClassPaths.contains(path) && !path.contains(JAVA_HOME_PATH)) continue;
            iterator.remove();
        }
    }
}

