/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.classloading;

import io.microsphere.annotation.Nullable;
import io.microsphere.classloading.Artifact;
import io.microsphere.classloading.ArtifactDetector;
import io.microsphere.classloading.MavenArtifact;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.SystemUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.List;

public class BannedArtifactClassLoadingExecutor {
    public static final String CONFIG_LOCATION = "META-INF/banned-artifacts";
    private static final Logger logger = LoggerFactory.getLogger(BannedArtifactClassLoadingExecutor.class);
    private static final String ENCODING = SystemUtils.FILE_ENCODING;
    private final ArtifactDetector artifactDetector;
    private final ClassLoader classLoader;

    public BannedArtifactClassLoadingExecutor() {
        this(null);
    }

    public BannedArtifactClassLoadingExecutor(@Nullable ClassLoader classLoader) {
        this.artifactDetector = new ArtifactDetector(classLoader);
        this.classLoader = this.artifactDetector.classLoader;
    }

    public void execute() {
        List<MavenArtifact> bannedArtifactConfigs = this.loadBannedArtifactConfigs();
        List<Artifact> artifacts = this.artifactDetector.detect(false);
        for (Artifact artifact : artifacts) {
            URL classPathURL = artifact.getLocation();
            if (classPathURL == null) continue;
            for (MavenArtifact bannedArtifactConfig : bannedArtifactConfigs) {
                if (!bannedArtifactConfig.matches(artifact)) continue;
                ClassLoaderUtils.removeClassPathURL(this.classLoader, classPathURL);
            }
        }
    }

    private List<MavenArtifact> loadBannedArtifactConfigs() {
        LinkedList<MavenArtifact> bannedArtifactConfigs = new LinkedList<MavenArtifact>();
        try {
            Enumeration<URL> configResources = this.classLoader.getResources(CONFIG_LOCATION);
            while (configResources.hasMoreElements()) {
                URL configResource = configResources.nextElement();
                List<MavenArtifact> configs = this.loadBannedArtifactConfigs(configResource);
                bannedArtifactConfigs.addAll(configs);
            }
        }
        catch (IOException e) {
            logger.error("The banned artifacts config resource[{}] can't be read", CONFIG_LOCATION, e);
        }
        return bannedArtifactConfigs;
    }

    private List<MavenArtifact> loadBannedArtifactConfigs(URL configResource) throws IOException {
        LinkedList<MavenArtifact> bannedArtifactConfigs = new LinkedList<MavenArtifact>();
        try (InputStream inputStream = configResource.openStream();
             BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream, ENCODING));){
            String definition;
            while (!StringUtils.isBlank(definition = reader.readLine())) {
                MavenArtifact bannedArtifactConfig = this.loadBannedArtifactConfig(definition);
                bannedArtifactConfigs.add(bannedArtifactConfig);
            }
        }
        return bannedArtifactConfigs;
    }

    private MavenArtifact loadBannedArtifactConfig(String definition) {
        String[] gav = StringUtils.split(definition.trim(), ":");
        if (gav.length != 3) {
            throw new RuntimeException("The definition of the banned artifact must contain groupId, artifactId and version : " + definition);
        }
        String groupId = gav[0];
        String artifactId = gav[1];
        String version = gav[2];
        return MavenArtifact.create(groupId, artifactId, version);
    }
}

