/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.classloading;

import io.microsphere.annotation.ConfigurationProperty;
import io.microsphere.classloading.Artifact;
import io.microsphere.classloading.StreamArtifactResourceResolver;
import io.microsphere.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

public class ManifestArtifactResourceResolver
extends StreamArtifactResourceResolver {
    public static final String DEFAULT_ARTIFACT_ID_ATTRIBUTE_NAMES_PROPERTY_VALUE = "Bundle-Name,Automatic-Module-Name,Implementation-Title";
    public static final String DEFAULT_VERSION_ATTRIBUTE_NAMES_PROPERTY_VALUE = "Bundle-Version,Implementation-Version";
    @ConfigurationProperty(type=String[].class, defaultValue="Bundle-Name,Automatic-Module-Name,Implementation-Title", description="The attribute names in the 'META-INF/MANIFEST' resource are retrieved as the artifact id")
    public static final String ARTIFACT_ID_ATTRIBUTE_NAMES_PROPERTY_NAME = "microsphere.artifact-id.manifest-attribute-names";
    @ConfigurationProperty(type=String[].class, defaultValue="Bundle-Version,Implementation-Version", description="The attribute names in the 'META-INF/MANIFEST' resource are retrieved as the artifact version")
    public static final String VERSION_ATTRIBUTE_NAMES_PROPERTY_NAME = "microsphere.artifact-version.manifest-attribute-names";
    public static final int DEFAULT_PRIORITY = 5;
    private static final String[] ARTIFACT_ID_ATTRIBUTE_NAMES = ManifestArtifactResourceResolver.getArtifactIdAttributeNames();
    private static final String[] VERSION_ATTRIBUTE_NAMES = ManifestArtifactResourceResolver.getVersionAttributeNames();

    private static String[] getArtifactIdAttributeNames() {
        return ManifestArtifactResourceResolver.getPropertyValues(ARTIFACT_ID_ATTRIBUTE_NAMES_PROPERTY_NAME, DEFAULT_ARTIFACT_ID_ATTRIBUTE_NAMES_PROPERTY_VALUE);
    }

    private static String[] getVersionAttributeNames() {
        return ManifestArtifactResourceResolver.getPropertyValues(VERSION_ATTRIBUTE_NAMES_PROPERTY_NAME, DEFAULT_VERSION_ATTRIBUTE_NAMES_PROPERTY_VALUE);
    }

    private static String[] getPropertyValues(String propertyName, String defaultValue) {
        String propertyValue = System.getProperty(propertyName, defaultValue);
        return StringUtils.split(propertyValue, ",");
    }

    public ManifestArtifactResourceResolver() {
        this(5);
    }

    public ManifestArtifactResourceResolver(int priority) {
        super(priority);
    }

    public ManifestArtifactResourceResolver(ClassLoader classLoader, int priority) {
        super(classLoader, priority);
    }

    @Override
    protected boolean isArtifactMetadata(String relativePath) {
        return "META-INF/MANIFEST.MF".equals(relativePath);
    }

    @Override
    protected Artifact resolve(URL resourceURL, InputStream artifactMetadataData, ClassLoader classLoader) throws IOException {
        Manifest manifest = new Manifest(artifactMetadataData);
        return this.resolveArtifactMetaInfoInManifest(manifest, resourceURL);
    }

    private Artifact resolveArtifactMetaInfoInManifest(Manifest manifest, URL resourceURL) throws IOException {
        Attributes mainAttributes = manifest.getMainAttributes();
        String artifactId = this.resolveArtifactId(mainAttributes, resourceURL);
        if (artifactId == null) {
            return null;
        }
        String version = this.resolveVersion(mainAttributes);
        return Artifact.create(artifactId, version, resourceURL);
    }

    private String resolveArtifactId(Attributes attributes, URL artifactResourceURL) {
        String artifactIdAttributeName;
        String artifactId = null;
        String[] stringArray = ARTIFACT_ID_ATTRIBUTE_NAMES;
        int n = stringArray.length;
        for (int i = 0; i < n && (artifactId = attributes.getValue(artifactIdAttributeName = stringArray[i])) == null; ++i) {
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("The artifactId was resolved from the '{}' of resource URL['{}'] of  : {} , attributes : {}", "META-INF/MANIFEST.MF", artifactResourceURL.getPath(), artifactId, attributes.entrySet());
        }
        return artifactId;
    }

    private String resolveVersion(Attributes attributes) {
        String versionAttributeName;
        String version = null;
        String[] stringArray = VERSION_ATTRIBUTE_NAMES;
        int n = stringArray.length;
        for (int i = 0; i < n && (version = attributes.getValue(versionAttributeName = stringArray[i])) == null; ++i) {
        }
        return version;
    }
}

