/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.classloading;

import io.microsphere.classloading.Artifact;
import io.microsphere.classloading.MavenArtifact;
import io.microsphere.classloading.StreamArtifactResourceResolver;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;

public class MavenArtifactResourceResolver
extends StreamArtifactResourceResolver {
    public static final String MAVEN_POM_PROPERTIES_RESOURCE_PREFIX = "META-INF/maven/";
    public static final String MAVEN_POM_PROPERTIES_RESOURCE_SUFFIX = "/pom.properties";
    public static final String GROUP_ID_PROPERTY_NAME = "groupId";
    public static final String ARTIFACT_ID_PROPERTY_NAME = "artifactId";
    public static final String VERSION_PROPERTY_NAME = "version";
    public static final int DEFAULT_PRIORITY = 1;

    public MavenArtifactResourceResolver() {
        this(1);
    }

    public MavenArtifactResourceResolver(int priority) {
        super(priority);
    }

    public MavenArtifactResourceResolver(ClassLoader classLoader, int priority) {
        super(classLoader, priority);
    }

    @Override
    protected boolean isArtifactMetadata(String relativePath) {
        int begin = relativePath.indexOf(MAVEN_POM_PROPERTIES_RESOURCE_PREFIX);
        if (begin == 0) {
            int end = relativePath.lastIndexOf(MAVEN_POM_PROPERTIES_RESOURCE_SUFFIX);
            return end > (begin += MAVEN_POM_PROPERTIES_RESOURCE_PREFIX.length());
        }
        return false;
    }

    @Override
    protected Artifact resolve(URL resourceURL, InputStream artifactMetadataData, ClassLoader classLoader) throws IOException {
        Properties properties = new Properties();
        properties.load(artifactMetadataData);
        return this.resolveArtifactMetaInfoInMavenPomProperties(properties, resourceURL);
    }

    Artifact resolveArtifactMetaInfoInMavenPomProperties(Properties properties, URL artifactResourceURL) {
        String groupId = properties.getProperty(GROUP_ID_PROPERTY_NAME);
        String artifactId = properties.getProperty(ARTIFACT_ID_PROPERTY_NAME);
        String version = properties.getProperty(VERSION_PROPERTY_NAME);
        return MavenArtifact.create(groupId, artifactId, version, artifactResourceURL);
    }
}

