/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.classloading;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.lang.Prioritized;
import io.microsphere.net.URLUtils;
import io.microsphere.util.ClassLoaderUtils;
import java.net.URL;
import java.net.URLClassLoader;

public interface URLClassPathHandle
extends Prioritized {
    public boolean supports();

    @Nonnull
    default public URL[] getURLs(@Nullable ClassLoader classLoader) {
        URLClassLoader urlClassLoader = ClassLoaderUtils.findURLClassLoader(classLoader);
        if (urlClassLoader == null) {
            return URLUtils.EMPTY_URL_ARRAY;
        }
        return urlClassLoader.getURLs();
    }

    default public boolean initializeLoaders(@Nullable ClassLoader classLoader) {
        URLClassLoader urlClassLoader = ClassLoaderUtils.findURLClassLoader(classLoader);
        if (urlClassLoader == null) {
            return false;
        }
        urlClassLoader.findResource("just-for-initializing-loaders");
        return true;
    }

    public boolean removeURL(@Nullable ClassLoader var1, @Nullable URL var2);

    @Override
    default public int getPriority() {
        return Integer.MAX_VALUE;
    }
}

