/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.EmptyIterable;
import io.microsphere.collection.EnumerationIteratorAdapter;
import io.microsphere.collection.IterableAdapter;
import io.microsphere.collection.ListUtils;
import io.microsphere.collection.QueueUtils;
import io.microsphere.collection.SingletonEnumeration;
import io.microsphere.collection.SingletonIterator;
import io.microsphere.collection.UnmodifiableIterator;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.Queue;

public abstract class CollectionUtils
implements Utils {
    public static boolean isEmpty(@Nullable Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(@Nullable Collection<?> collection) {
        return !CollectionUtils.isEmpty(collection);
    }

    @Nonnull
    public static <E> Iterable<E> toIterable(@Nullable Collection<E> collection) {
        return collection == null ? EmptyIterable.INSTANCE : collection;
    }

    @Nonnull
    public static <E> Iterable<E> toIterable(@Nullable Iterator<E> iterator) {
        return new IterableAdapter<E>(iterator);
    }

    @Nonnull
    public static <E> Iterator<E> toIterator(@Nullable Enumeration<E> enumeration) {
        return new EnumerationIteratorAdapter<E>(enumeration);
    }

    @Nonnull
    public static <E> Iterable<E> toIterable(@Nullable Enumeration<E> enumeration) {
        return CollectionUtils.toIterable(CollectionUtils.toIterator(enumeration));
    }

    @Nonnull
    public static <E> Iterable<E> singletonIterable(@Nullable E element) {
        return CollectionUtils.toIterable(CollectionUtils.singletonIterator(element));
    }

    @Nonnull
    public static <E> Iterator<E> singletonIterator(@Nullable E element) {
        return new SingletonIterator<E>(element);
    }

    @Nonnull
    public static <E> Enumeration<E> singletonEnumeration(@Nullable E element) {
        return new SingletonEnumeration<E>(element);
    }

    @Nonnull
    public static <E> Iterator<E> unmodifiableIterator(@Nullable Iterator<E> iterator) {
        return new UnmodifiableIterator<E>(iterator);
    }

    @Nonnull
    public static <E> Iterator<E> emptyIterator() {
        return Collections.emptyIterator();
    }

    @Nonnull
    public static <E> Iterable<E> emptyIterable() {
        return EmptyIterable.INSTANCE;
    }

    public static int size(@Nullable Collection<?> collection) {
        return collection == null ? 0 : collection.size();
    }

    public static int size(@Nullable Iterable<?> iterable) {
        if (iterable == null) {
            return 0;
        }
        if (iterable instanceof Collection) {
            return CollectionUtils.size((Collection)iterable);
        }
        Iterator<?> iterator = iterable.iterator();
        int size = 0;
        while (iterator.hasNext()) {
            iterator.next();
            ++size;
        }
        return size;
    }

    public static boolean equals(@Nullable Collection<?> one, @Nullable Collection<?> another) {
        if (one == another) {
            return true;
        }
        if (CollectionUtils.isEmpty(one) && CollectionUtils.isEmpty(another)) {
            return true;
        }
        if (CollectionUtils.size(one) != CollectionUtils.size(another)) {
            return false;
        }
        return one.containsAll(another);
    }

    public static <T> int addAll(@Nullable Collection<T> collection, T ... values) {
        if (collection == null) {
            return 0;
        }
        int size = ArrayUtils.length(values);
        if (size < 1) {
            return 0;
        }
        int effectedCount = 0;
        for (int i = 0; i < size; ++i) {
            if (!collection.add(values[i])) continue;
            ++effectedCount;
        }
        return effectedCount;
    }

    @Nullable
    public static <T> T first(@Nullable Collection<T> values) {
        if (CollectionUtils.isEmpty(values)) {
            return null;
        }
        if (ListUtils.isList(values)) {
            return (T)ListUtils.first((List)values);
        }
        return CollectionUtils.first(values);
    }

    @Nullable
    public static <T> T first(@Nullable Iterable<T> values) {
        return values == null ? null : (T)CollectionUtils.first(values.iterator());
    }

    @Nullable
    public static <T> T first(@Nullable Iterator<T> values) {
        if (values == null || !values.hasNext()) {
            return null;
        }
        return values.next();
    }

    public static <T> Queue<T> emptyQueue() {
        return QueueUtils.emptyQueue();
    }

    public static <T> Deque<T> emptyDeque() {
        return QueueUtils.emptyDeque();
    }

    private CollectionUtils() {
    }
}

