/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.collection.DelegatingQueue;
import io.microsphere.collection.QueueUtils;
import io.microsphere.invoke.MethodHandlesLookupUtils;
import io.microsphere.lang.function.ThrowableSupplier;
import java.lang.invoke.MethodHandle;
import java.util.Deque;
import java.util.Iterator;

public class DelegatingDeque<E>
extends DelegatingQueue<E>
implements Deque<E> {
    private static final MethodHandle reversedMethodHandle = MethodHandlesLookupUtils.findPublicVirtual(Deque.class, "reversed", new Class[0]);

    public DelegatingDeque(Deque<E> delegate) {
        super(delegate);
    }

    @Override
    public void addFirst(E e) {
        this.getDelegate().addFirst(e);
    }

    @Override
    public void addLast(E e) {
        this.getDelegate().addLast(e);
    }

    @Override
    public boolean offerFirst(E e) {
        return this.getDelegate().offerFirst(e);
    }

    @Override
    public boolean offerLast(E e) {
        return this.getDelegate().offerLast(e);
    }

    @Override
    public E removeFirst() {
        return this.getDelegate().removeFirst();
    }

    @Override
    public E removeLast() {
        return this.getDelegate().removeLast();
    }

    @Override
    public E pollFirst() {
        return this.getDelegate().pollFirst();
    }

    @Override
    public E pollLast() {
        return this.getDelegate().pollLast();
    }

    @Override
    public E getFirst() {
        return this.getDelegate().getFirst();
    }

    @Override
    public E getLast() {
        return this.getDelegate().getLast();
    }

    @Override
    public E peekFirst() {
        return this.getDelegate().peekFirst();
    }

    @Override
    public E peekLast() {
        return this.getDelegate().peekLast();
    }

    @Override
    public boolean removeFirstOccurrence(Object o) {
        return this.getDelegate().removeFirstOccurrence(o);
    }

    @Override
    public boolean removeLastOccurrence(Object o) {
        return this.getDelegate().removeLastOccurrence(o);
    }

    @Override
    public void push(E e) {
        this.getDelegate().push(e);
    }

    @Override
    public E pop() {
        return this.getDelegate().pop();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.getDelegate().descendingIterator();
    }

    @Override
    public Deque<E> getDelegate() {
        return (Deque)super.getDelegate();
    }

    @Override
    public Deque<E> reversed() {
        if (reversedMethodHandle == null) {
            return QueueUtils.reversedDeque(this.getDelegate());
        }
        return ThrowableSupplier.execute(() -> reversedMethodHandle.invokeExact((Deque)this.getDelegate()));
    }
}

