/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.annotation.Nonnull;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.collection.DefaultEntry;
import io.microsphere.collection.ImmutableEntry;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ConcurrentNavigableMap;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.function.Function;

public abstract class MapUtils
implements Utils {
    public static final float MIN_LOAD_FACTOR = Float.MIN_VALUE;
    public static final float FIXED_LOAD_FACTOR = 1.0f;

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return !MapUtils.isEmpty(map);
    }

    @Nonnull
    public static <K, V> Map<K, V> of(K key, V value) {
        return MapUtils.ofMap(key, value);
    }

    @Nonnull
    public static <K, V> Map<K, V> of(K key1, V value1, K key2, V value2) {
        return MapUtils.ofMap(key1, value1, key2, value2);
    }

    @Nonnull
    public static <K, V> Map<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3) {
        return MapUtils.ofMap(key1, value1, key2, value2, key3, value3);
    }

    @Nonnull
    public static <K, V> Map<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4) {
        return MapUtils.ofMap(key1, value1, key2, value2, key3, value3, key4, value4);
    }

    @Nonnull
    public static <K, V> Map<K, V> of(K key1, V value1, K key2, V value2, K key3, V value3, K key4, V value4, K key5, V value5) {
        return MapUtils.ofMap(key1, value1, key2, value2, key3, value3, key4, value4, key5, value5);
    }

    @Nonnull
    public static Map of(Object ... values) {
        return MapUtils.ofMap(values);
    }

    @Nonnull
    public static <K, V> Map<K, V> of(Map.Entry<? extends K, ? extends V> ... entries) {
        int length = ArrayUtils.length(entries);
        if (length < 1) {
            return Collections.emptyMap();
        }
        Map<K, V> map = MapUtils.newFixedLinkedHashMap(length);
        for (int i = 0; i < length; ++i) {
            Map.Entry<K, V> entry = entries[i];
            map.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(map);
    }

    @Nonnull
    public static <K, V> Map<K, V> ofMap(K key, V value) {
        return Collections.singletonMap(key, value);
    }

    @Nonnull
    public static Map ofMap(Object ... keyValuePairs) {
        int length = ArrayUtils.length(keyValuePairs);
        if (length < 1) {
            return Collections.emptyMap();
        }
        int size = length / 2;
        Map<Object, Object> map = MapUtils.newFixedLinkedHashMap(size);
        int i = 0;
        while (i < length) {
            map.put(keyValuePairs[i++], keyValuePairs[i++]);
        }
        return Collections.unmodifiableMap(map);
    }

    @Nonnull
    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    @Nonnull
    public static <K, V> HashMap<K, V> newHashMap(int initialCapacity) {
        return new HashMap(initialCapacity);
    }

    @Nonnull
    public static <K, V> HashMap<K, V> newHashMap(int initialCapacity, float loadFactor) {
        return new HashMap(initialCapacity, loadFactor);
    }

    @Nonnull
    public static <K, V> HashMap<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        return new HashMap<K, V>(map);
    }

    @Nonnull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    @Nonnull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int initialCapacity) {
        return new LinkedHashMap(initialCapacity);
    }

    @Nonnull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int initialCapacity, float loadFactor) {
        return new LinkedHashMap(initialCapacity, loadFactor);
    }

    @Nonnull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(int initialCapacity, float loadFactor, boolean accessOrder) {
        return new LinkedHashMap(initialCapacity, loadFactor, accessOrder);
    }

    @Nonnull
    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<? extends K, ? extends V> map) {
        return new LinkedHashMap<K, V>(map);
    }

    @Nonnull
    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap() {
        return new ConcurrentHashMap();
    }

    @Nonnull
    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity) {
        return new ConcurrentHashMap(initialCapacity);
    }

    @Nonnull
    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(int initialCapacity, float loadFactor) {
        return new ConcurrentHashMap(initialCapacity, loadFactor);
    }

    @Nonnull
    public static <K, V> ConcurrentHashMap<K, V> newConcurrentHashMap(Map<? extends K, ? extends V> map) {
        return new ConcurrentHashMap<K, V>(map);
    }

    @Nonnull
    public static <K, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    @Nonnull
    public static <K, V> TreeMap<K, V> newTreeMap(Comparator<? super K> comparator) {
        return new TreeMap(comparator);
    }

    @Nonnull
    public static <K, V> TreeMap<K, V> newTreeMap(Map<? extends K, ? extends V> map) {
        return new TreeMap<K, V>(map);
    }

    @Nonnull
    public static <K, V> TreeMap<K, V> newTreeMap(SortedMap<K, ? extends V> map) {
        return new TreeMap<K, V>(map);
    }

    @Nonnull
    public static <K, V> Map<K, V> shallowCloneMap(@Nonnull Map<K, V> source) {
        if (source instanceof LinkedHashMap) {
            return new LinkedHashMap<K, V>(source);
        }
        if (source instanceof ConcurrentNavigableMap) {
            return new ConcurrentSkipListMap<K, V>(source);
        }
        if (source instanceof SortedMap) {
            return new TreeMap<K, V>(source);
        }
        if (source instanceof ConcurrentMap) {
            return new ConcurrentHashMap<K, V>(source);
        }
        if (source instanceof IdentityHashMap) {
            return new IdentityHashMap<K, V>(source);
        }
        return new HashMap<K, V>(source);
    }

    @Nonnull
    public static <K, V> Map<K, V> newFixedHashMap(int size) {
        return MapUtils.newHashMap(size, 1.0f);
    }

    @Nonnull
    public static <K, V> Map<K, V> newFixedLinkedHashMap(int size) {
        return MapUtils.newLinkedHashMap(size, 1.0f);
    }

    @Nonnull
    public static <K, V, E> Map<K, V> toFixedMap(Collection<E> values, Function<E, Map.Entry<K, V>> entryMapper) {
        int size = CollectionUtils.size(values);
        if (size < 1) {
            return Collections.emptyMap();
        }
        Map<K, V> fixedMap = MapUtils.newFixedLinkedHashMap(size);
        for (E value : values) {
            Map.Entry<K, V> entry = entryMapper.apply(value);
            fixedMap.put(entry.getKey(), entry.getValue());
        }
        return Collections.unmodifiableMap(fixedMap);
    }

    @Nonnull
    public static <K, V> Map.Entry<K, V> ofEntry(K key, V value) {
        return DefaultEntry.of(key, value);
    }

    @Nonnull
    public static <K, V> Map.Entry<K, V> immutableEntry(K key, V value) {
        return ImmutableEntry.of(key, value);
    }

    private MapUtils() {
    }
}

