/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.annotation.Nonnull;
import io.microsphere.collection.EmptyDeque;
import io.microsphere.collection.ReversedDeque;
import io.microsphere.collection.SingletonDeque;
import io.microsphere.collection.UnmodifiableDeque;
import io.microsphere.collection.UnmodifiableQueue;
import io.microsphere.util.Utils;
import java.util.Deque;
import java.util.Queue;

public abstract class QueueUtils
implements Utils {
    public static final Deque<?> EMPTY_DEQUE = EmptyDeque.INSTANCE;

    public static boolean isQueue(Iterable<?> values) {
        return values instanceof Queue;
    }

    public static boolean isDeque(Iterable<?> values) {
        return values instanceof Deque;
    }

    @Nonnull
    public static <E> Queue<E> emptyQueue() {
        return EMPTY_DEQUE;
    }

    public static <E> Deque<E> emptyDeque() {
        return EMPTY_DEQUE;
    }

    @Nonnull
    public static <E> Queue<E> unmodifiableQueue(Queue<E> queue) {
        return new UnmodifiableQueue<E>(queue);
    }

    public static <E> Deque<E> unmodifiableDeque(Deque<E> deque) {
        return new UnmodifiableDeque<E>(deque);
    }

    public static <E> Queue<E> singletonQueue(E element) {
        return new SingletonDeque<E>(element);
    }

    public static <E> Deque<E> singletonDeque(E element) {
        return new SingletonDeque<E>(element);
    }

    public static <E> Deque<E> reversedDeque(Deque<E> deque) {
        return ReversedDeque.of(deque);
    }

    private QueueUtils() {
    }
}

