/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.collection;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Utils;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public abstract class SetUtils
implements Utils {
    public static boolean isSet(@Nullable Iterable<?> elements) {
        return elements instanceof Set;
    }

    @Nonnull
    public static <E> Set<E> of(E ... elements) {
        return SetUtils.ofSet(elements);
    }

    @Nonnull
    public static <E> Set<E> ofSet(E ... elements) {
        int size = ArrayUtils.length(elements);
        if (size < 1) {
            return Collections.emptySet();
        }
        if (size == 1) {
            return Collections.singleton(elements[0]);
        }
        LinkedHashSet<E> set = new LinkedHashSet<E>(size, 1.0f);
        for (int i = 0; i < size; ++i) {
            set.add(elements[i]);
        }
        return Collections.unmodifiableSet(set);
    }

    @Nonnull
    public static <E> Set<E> ofSet(Enumeration<E> elements) {
        if (elements == null || !elements.hasMoreElements()) {
            return Collections.emptySet();
        }
        Set<E> set = SetUtils.newLinkedHashSet();
        while (elements.hasMoreElements()) {
            set.add(elements.nextElement());
        }
        return Collections.unmodifiableSet(set);
    }

    @Nonnull
    public static <E> Set<E> ofSet(Iterable<E> elements) {
        if (elements == null) {
            return Collections.emptySet();
        }
        if (elements instanceof Collection) {
            return SetUtils.ofSet((Collection)elements);
        }
        return Collections.unmodifiableSet(SetUtils.newLinkedHashSet(elements));
    }

    @Nonnull
    public static <T> Set<T> ofSet(Collection<T> elements) {
        return SetUtils.ofSet(elements, (Object[])null);
    }

    @Nonnull
    public static <T> Set<T> ofSet(Collection<T> elements, T ... others) {
        int valuesSize = CollectionUtils.size(elements);
        if (valuesSize < 1) {
            return SetUtils.of(others);
        }
        int othersSize = ArrayUtils.length(others);
        int size = valuesSize + othersSize;
        Set<T> set = SetUtils.newLinkedHashSet(size, 1.0f);
        set.addAll(elements);
        for (int i = 0; i < othersSize; ++i) {
            set.add(others[i]);
        }
        return Collections.unmodifiableSet(set);
    }

    @Nonnull
    public static <E> Set<E> newHashSet(Iterable<E> elements) {
        Set<E> set = SetUtils.newHashSet();
        for (E value : elements) {
            set.add(value);
        }
        return set;
    }

    @Nonnull
    public static <E> Set<E> newHashSet(Collection<E> elements) {
        return new HashSet<E>(elements);
    }

    @Nonnull
    public static <E> Set<E> newHashSet(E ... elements) {
        int length = ArrayUtils.length(elements);
        Set<E> set = SetUtils.newHashSet(length);
        for (int i = 0; i < length; ++i) {
            set.add(elements[i]);
        }
        return set;
    }

    @Nonnull
    public static <E> Set<E> newHashSet() {
        return new HashSet();
    }

    @Nonnull
    public static <E> Set<E> newHashSet(int initialCapacity) {
        return new HashSet(initialCapacity);
    }

    public static <E> Set<E> newHashSet(int initialCapacity, float loadFactor) {
        return new HashSet(initialCapacity, loadFactor);
    }

    public static <E> Set<E> newLinkedHashSet(Iterable<E> elements) {
        return SetUtils.newLinkedHashSet(elements.iterator());
    }

    @Nonnull
    public static <E> Set<E> newLinkedHashSet(Iterator<E> elements) {
        Set<E> set = SetUtils.newLinkedHashSet();
        while (elements.hasNext()) {
            E value = elements.next();
            set.add(value);
        }
        return set;
    }

    @Nonnull
    public static <E> Set<E> newLinkedHashSet(Collection<E> elements) {
        return new LinkedHashSet<E>(elements);
    }

    @Nonnull
    public static <E> Set<E> newLinkedHashSet(E ... elements) {
        int length = ArrayUtils.length(elements);
        Set<E> set = SetUtils.newLinkedHashSet(length);
        for (int i = 0; i < length; ++i) {
            set.add(elements[i]);
        }
        return set;
    }

    @Nonnull
    public static <E> Set<E> newLinkedHashSet() {
        return new LinkedHashSet();
    }

    @Nonnull
    public static <E> Set<E> newLinkedHashSet(int initialCapacity) {
        return new LinkedHashSet(initialCapacity);
    }

    @Nonnull
    public static <E> Set<E> newLinkedHashSet(int initialCapacity, float loadFactor) {
        return new LinkedHashSet(initialCapacity, loadFactor);
    }

    private SetUtils() {
    }
}

