/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.concurrent;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class CustomizedThreadFactory
implements ThreadFactory {
    public static final boolean DEFAULT_DAEMON = true;
    public static final int DEFAULT_PRIORITY = 5;
    public static final long DEFAULT_STACK_SIZE = 0L;
    private final ThreadGroup group;
    private final AtomicInteger threadNumber;
    private final String namePrefix;
    private final boolean daemon;
    private final int priority;
    private final long stackSize;

    protected CustomizedThreadFactory(String namePrefix, boolean daemon, int priority, long stackSize) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.threadNumber = new AtomicInteger(1);
        this.namePrefix = namePrefix + "-thread-";
        this.daemon = daemon;
        this.priority = priority;
        this.stackSize = stackSize;
    }

    public static ThreadFactory newThreadFactory(String namePrefix) {
        return CustomizedThreadFactory.newThreadFactory(namePrefix, true);
    }

    public static ThreadFactory newThreadFactory(String namePrefix, boolean daemon) {
        return CustomizedThreadFactory.newThreadFactory(namePrefix, daemon, 5);
    }

    public static ThreadFactory newThreadFactory(String namePrefix, boolean daemon, int priority) {
        return CustomizedThreadFactory.newThreadFactory(namePrefix, daemon, priority, 0L);
    }

    public static ThreadFactory newThreadFactory(String namePrefix, boolean daemon, int priority, long stackSize) {
        return new CustomizedThreadFactory(namePrefix, daemon, priority, stackSize);
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.namePrefix + this.threadNumber.getAndIncrement(), this.stackSize);
        t.setDaemon(this.daemon);
        t.setPriority(this.priority);
        return t;
    }
}

