/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.concurrent;

import io.microsphere.util.ArrayUtils;
import io.microsphere.util.ShutdownHookUtils;
import io.microsphere.util.Utils;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;

public abstract class ExecutorUtils
implements Utils {
    public static void shutdownOnExit(Executor one, Executor ... others) {
        ShutdownHookUtils.addShutdownHookCallback(() -> {
            ExecutorUtils.shutdown(one);
            ArrayUtils.forEach(others, other -> ExecutorUtils.shutdown(other));
        });
    }

    public static boolean shutdown(Executor executor) {
        if (executor instanceof ExecutorService) {
            return ExecutorUtils.shutdown((ExecutorService)executor);
        }
        return false;
    }

    public static boolean shutdown(ExecutorService executorService) {
        if (executorService == null) {
            return false;
        }
        if (!executorService.isShutdown()) {
            executorService.shutdown();
        }
        return true;
    }

    private ExecutorUtils() {
    }
}

