/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.convert;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.convert.Converter;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.ExceptionUtils;
import java.util.List;
import java.util.Objects;

public abstract class AbstractConverter<S, T>
implements Converter<S, T> {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Nullable
    private Integer priority = this.resolvePriority();

    @Override
    @Nullable
    public final T convert(@Nullable S source) {
        if (source == null) {
            return null;
        }
        T target = null;
        try {
            target = this.doConvert(source);
        }
        catch (Throwable e) {
            if (this.logger.isTraceEnabled()) {
                this.logger.trace("The source[value : {}] can't be converted by the Converter[class : '{}']", source, ClassUtils.getTypeName(this.getClass()));
            }
            throw ExceptionUtils.wrap(e, RuntimeException.class);
        }
        return target;
    }

    @Nullable
    protected abstract T doConvert(@Nonnull S var1) throws Throwable;

    protected Integer resolvePriority() {
        Class sourceType = this.getSourceType();
        Class targetType = this.getTargetType();
        List<Class<?>> allTypesFromSource = ClassUtils.getAllClasses(sourceType);
        List<Class<?>> allTypesFromTarget = ClassUtils.getAllClasses(targetType);
        int high = allTypesFromSource.size() << 16;
        int low = allTypesFromTarget.size();
        return -(high | low);
    }

    @Override
    public int getPriority() {
        return this.priority == null ? Converter.super.getPriority() : this.priority.intValue();
    }

    public boolean equals(Object o) {
        if (!(o instanceof AbstractConverter)) {
            return false;
        }
        AbstractConverter that = (AbstractConverter)o;
        return Objects.equals(this.getSourceType(), that.getSourceType()) && Objects.equals(this.getTargetType(), that.getTargetType()) && Objects.equals(this.getPriority(), that.getPriority());
    }

    public int hashCode() {
        return Objects.hash(this.getSourceType(), this.getTargetType(), this.getPriority());
    }
}

