/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.convert;

import io.microsphere.annotation.Nonnull;
import io.microsphere.convert.AbstractConverter;
import io.microsphere.convert.StringConverter;
import io.microsphere.io.FastByteArrayInputStream;
import io.microsphere.nio.charset.CharsetUtils;
import java.io.InputStream;
import java.nio.charset.Charset;

public class StringToInputStreamConverter
extends AbstractConverter<String, InputStream>
implements StringConverter<InputStream> {
    public static final StringToInputStreamConverter INSTANCE = new StringToInputStreamConverter();
    private final Charset charset;

    public StringToInputStreamConverter() {
        this(CharsetUtils.DEFAULT_CHARSET);
    }

    public StringToInputStreamConverter(String encoding) {
        this(Charset.forName(encoding));
    }

    public StringToInputStreamConverter(Charset charset) {
        this.charset = charset;
    }

    @Override
    protected InputStream doConvert(String source) {
        byte[] bytes = source.getBytes(this.charset);
        return new FastByteArrayInputStream(bytes);
    }

    @Nonnull
    public Charset getCharset() {
        return this.charset;
    }
}

