/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.event;

import io.microsphere.event.Event;
import io.microsphere.lang.Prioritized;
import io.microsphere.reflect.TypeUtils;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;

@FunctionalInterface
public interface EventListener<E extends Event>
extends java.util.EventListener,
Prioritized {
    public static Class<? extends Event> findEventType(EventListener<?> listener) {
        return EventListener.findEventType(listener.getClass());
    }

    public static Class<? extends Event> findEventType(Class<?> listenerClass) {
        Class<Event> eventType = null;
        if (listenerClass != null && EventListener.class.isAssignableFrom(listenerClass)) {
            eventType = TypeUtils.getAllParameterizedTypes(listenerClass).stream().map(EventListener::findEventType).filter(Objects::nonNull).findAny().orElse(EventListener.findEventType(listenerClass.getSuperclass()));
        }
        return eventType;
    }

    public static Class<? extends Event> findEventType(ParameterizedType parameterizedType) {
        Class eventType = null;
        Type rawType = parameterizedType.getRawType();
        if (rawType instanceof Class && EventListener.class.isAssignableFrom((Class)rawType)) {
            Type[] typeArguments;
            for (Type typeArgument : typeArguments = parameterizedType.getActualTypeArguments()) {
                Class argumentClass;
                if (!(typeArgument instanceof Class) || !Event.class.isAssignableFrom(argumentClass = (Class)typeArgument)) continue;
                eventType = argumentClass;
                break;
            }
        }
        return eventType;
    }

    public void onEvent(E var1);

    @Override
    default public int getPriority() {
        return 0;
    }
}

