/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.filter;

import io.microsphere.filter.Filter;
import io.microsphere.util.ArrayUtils;

public enum FilterOperator {
    AND{

        @Override
        public <T> boolean accept(T filteredObject, Filter<T> ... filters) {
            int length = ArrayUtils.length(filters);
            if (length == 0) {
                return true;
            }
            boolean success = true;
            for (Filter<T> filter : filters) {
                success &= filter.accept(filteredObject);
            }
            return success;
        }
    }
    ,
    OR{

        @Override
        public <T> boolean accept(T filteredObject, Filter<T> ... filters) {
            int length = ArrayUtils.length(filters);
            if (length == 0) {
                return true;
            }
            boolean success = false;
            for (Filter<T> filter : filters) {
                success |= filter.accept(filteredObject);
            }
            return success;
        }
    }
    ,
    XOR{

        @Override
        public <T> boolean accept(T filteredObject, Filter<T> ... filters) {
            int length = ArrayUtils.length(filters);
            if (length == 0) {
                return true;
            }
            boolean success = true;
            for (Filter<T> filter : filters) {
                success ^= filter.accept(filteredObject);
            }
            return success;
        }
    };


    public abstract <T> boolean accept(T var1, Filter<T> ... var2);

    public final <T> Filter<T> createFilter(final Filter<T> ... filters) {
        final FilterOperator self = this;
        return new Filter<T>(){

            @Override
            public boolean accept(T filteredObject) {
                return self.accept(filteredObject, filters);
            }
        };
    }
}

