/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.filter;

import io.microsphere.filter.Filter;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.StringUtils;

public class PackageNameClassNameFilter
implements Filter<String> {
    private final String packageName;
    private final boolean includedSubPackages;
    private final String subPackageNamePrefix;

    public PackageNameClassNameFilter(String packageName, boolean includedSubPackages) {
        this.packageName = packageName;
        this.includedSubPackages = includedSubPackages;
        this.subPackageNamePrefix = includedSubPackages ? packageName + '.' : null;
    }

    @Override
    public boolean accept(String className) {
        if (StringUtils.isBlank(className)) {
            return false;
        }
        String packageName = ClassUtils.resolvePackageName(className);
        boolean accepted = packageName.equals(this.packageName);
        if (!accepted && this.includedSubPackages) {
            accepted = packageName.startsWith(this.subPackageNamePrefix);
        }
        return accepted;
    }
}

