/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.invoke;

import io.microsphere.invoke.MethodHandlesLookupUtils;
import io.microsphere.lang.function.ThrowableBiFunction;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.reflect.ConstructorUtils;
import io.microsphere.reflect.MemberUtils;
import io.microsphere.reflect.MethodUtils;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Utils;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public abstract class MethodHandleUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandleUtils.class);
    public static final int MODULE = 16;
    public static final int UNCONDITIONAL = 32;
    public static final int ORIGINAL = 64;
    public static final int ALL_MODES = 127;
    private static final Constructor<MethodHandles.Lookup> lookupConstructor1 = ConstructorUtils.getDeclaredConstructor(MethodHandles.Lookup.class, Class.class);
    private static final Constructor<MethodHandles.Lookup> lookupConstructor2 = ConstructorUtils.findConstructor(MethodHandles.Lookup.class, Class.class, Integer.TYPE);
    private static final Constructor<MethodHandles.Lookup> lookupConstructor3 = ConstructorUtils.findConstructor(MethodHandles.Lookup.class, Class.class, Class.class, Integer.TYPE);
    private static final ConcurrentMap<LookupKey, MethodHandles.Lookup> lookupCache = new ConcurrentHashMap<LookupKey, MethodHandles.Lookup>();
    public static final MethodHandles.Lookup PUBLIC_LOOKUP = MethodHandles.publicLookup();

    public static MethodHandles.Lookup lookup(Class<?> requestedClass) {
        return MethodHandleUtils.lookup(requestedClass, LookupMode.ALL);
    }

    public static MethodHandles.Lookup lookup(Class<?> requestedClass, LookupMode ... lookupModes) {
        int allowedModes = LookupMode.getModes(lookupModes);
        LookupKey key = LookupKey.buildKey(requestedClass, allowedModes);
        return lookupCache.computeIfAbsent(key, MethodHandleUtils::newLookup);
    }

    public static MethodHandle findVirtual(Class<?> requestedClass, String methodName, Class ... parameterTypes) {
        return MethodHandleUtils.find(requestedClass, methodName, parameterTypes, (lookup, methodType) -> lookup.findVirtual(requestedClass, methodName, (MethodType)methodType));
    }

    public static MethodHandle findStatic(Class<?> requestedClass, String methodName, Class ... parameterTypes) {
        return MethodHandleUtils.find(requestedClass, methodName, parameterTypes, (lookup, methodType) -> lookup.findStatic(requestedClass, methodName, (MethodType)methodType));
    }

    public static void handleInvokeExactFailure(Throwable e, MethodHandle methodHandle, Object ... args) {
        if (logger.isWarnEnabled()) {
            logger.warn("Failed to invokeExact on the {} with arguments : {}", methodHandle, ArrayUtils.arrayToString(args), e);
        }
    }

    protected static MethodHandle find(Class<?> requestedClass, String methodName, Class[] parameterTypes, ThrowableBiFunction<MethodHandles.Lookup, MethodType, MethodHandle> function) {
        Method method = MethodUtils.findMethod(requestedClass, methodName, parameterTypes);
        if (method == null) {
            return MethodHandlesLookupUtils.NOT_FOUND_METHOD_HANDLE;
        }
        if (MethodHandleUtils.isiCandidateMethod(method)) {
            return MethodHandlesLookupUtils.findPublic(method, function);
        }
        MethodHandles.Lookup lookup = MethodHandleUtils.lookup(requestedClass);
        return MethodHandlesLookupUtils.find(lookup, requestedClass, methodName, parameterTypes, function);
    }

    private static MethodHandles.Lookup newLookup(LookupKey key) {
        if (lookupConstructor3 != null) {
            return ConstructorUtils.newInstance(lookupConstructor3, key.requestedClass, key.requestedClass, key.allowedModes);
        }
        return ConstructorUtils.newInstance(lookupConstructor2, key.requestedClass, key.allowedModes);
    }

    private static boolean isiCandidateMethod(Method method) {
        return MemberUtils.isPublic(method) && !MethodUtils.isCallerSensitiveMethod(method);
    }

    private MethodHandleUtils() {
    }

    static class LookupKey {
        final Class<?> requestedClass;
        final int allowedModes;

        LookupKey(Class<?> requestedClass, int allowedModes) {
            this.requestedClass = requestedClass;
            this.allowedModes = allowedModes;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            LookupKey lookupKey = (LookupKey)o;
            return this.allowedModes == lookupKey.allowedModes && Objects.equals(this.requestedClass, lookupKey.requestedClass);
        }

        public int hashCode() {
            return Objects.hash(this.requestedClass, this.allowedModes);
        }

        static LookupKey buildKey(Class<?> requestedClass, int allowedModes) {
            return new LookupKey(requestedClass, allowedModes);
        }
    }

    public static enum LookupMode {
        PUBLIC(1),
        PRIVATE(2),
        PROTECTED(4),
        PACKAGE(8),
        MODULE(16),
        UNCONDITIONAL(32),
        ORIGINAL(64),
        ALL(127),
        TRUSTED(-1);

        private final int value;

        private LookupMode(int value) {
            this.value = value;
        }

        public static int getModes(LookupMode ... lookupModes) {
            int modes = 0;
            for (int i = 0; i < lookupModes.length; ++i) {
                LookupMode lookupMode = lookupModes[i];
                modes |= lookupMode.value;
            }
            return modes;
        }
    }
}

