/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io;

import io.microsphere.collection.ListUtils;
import io.microsphere.io.Deserializer;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ServiceLoaderUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Deserializers {
    private final Map<Class<?>, List<Deserializer>> typedDeserializers = new HashMap();
    private final ClassLoader classLoader;

    public Deserializers(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Deserializers() {
        this(ClassLoaderUtils.getDefaultClassLoader());
    }

    public void loadSPI() {
        for (Deserializer deserializer : ServiceLoaderUtils.loadServicesList(Deserializer.class, this.classLoader)) {
            List<Class<?>> typeArguments = TypeUtils.resolveTypeArgumentClasses(deserializer.getClass());
            Class<?> targetClass = ListUtils.first(typeArguments);
            List deserializers = this.typedDeserializers.computeIfAbsent(targetClass, k -> new LinkedList());
            deserializers.add(deserializer);
        }
    }

    public Deserializer<?> getMostCompatible(Class<?> deserializedType) {
        Deserializer deserializer = this.getHighestPriority(deserializedType);
        if (deserializer == null) {
            deserializer = this.getLowestPriority(Object.class);
        }
        return deserializer;
    }

    public <T> Deserializer<T> getHighestPriority(Class<?> deserializedType) {
        List<Deserializer<T>> serializers = this.get(deserializedType);
        return ListUtils.first(serializers);
    }

    public <T> Deserializer<T> getLowestPriority(Class<?> deserializedType) {
        List<Deserializer<T>> serializers = this.get(deserializedType);
        return ListUtils.last(serializers);
    }

    public <T> List<Deserializer<T>> get(Class<?> deserializedType) {
        return this.typedDeserializers.getOrDefault(deserializedType, Collections.emptyList());
    }
}

