/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io;

import io.microsphere.annotation.Nullable;
import io.microsphere.lang.function.ThrowableSupplier;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.CharSequenceUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.Files;

public abstract class FileUtils
implements Utils {
    public static final File[] EMPTY_FILE_ARRAY = ArrayUtils.EMPTY_FILE_ARRAY;

    @Nullable
    public static String resolveRelativePath(File parentDirectory, File targetFile) {
        if (!parentDirectory.isDirectory()) {
            return null;
        }
        String parentDirectoryPath = parentDirectory.getAbsolutePath();
        String targetFilePath = targetFile.getAbsolutePath();
        int index = targetFilePath.indexOf(parentDirectoryPath);
        if (index == 0) {
            String relativePath = targetFilePath.substring(parentDirectoryPath.length());
            if (CharSequenceUtils.isEmpty(relativePath)) {
                return relativePath;
            }
            return relativePath.substring(1).replace(File.separatorChar, '/');
        }
        return null;
    }

    @Nullable
    public static String getFileExtension(String fileName) {
        if (StringUtils.isBlank(fileName)) {
            return null;
        }
        int index = fileName.lastIndexOf(46);
        return index > -1 ? fileName.substring(index + 1) : null;
    }

    public static int deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return 0;
        }
        int deletedFilesCount = 0;
        if (!FileUtils.isSymlink(directory)) {
            deletedFilesCount += FileUtils.cleanDirectory(directory);
        }
        if (!directory.delete()) {
            String message = "Unable to delete directory " + directory + '.';
            throw new IOException(message);
        }
        return ++deletedFilesCount;
    }

    public static int cleanDirectory(File directory) throws IOException {
        int deletedFilesCount = 0;
        IOException exception = null;
        for (File file : FileUtils.listFiles(directory)) {
            try {
                deletedFilesCount += FileUtils.forceDelete(file);
            }
            catch (IOException ioe) {
                exception = ioe;
            }
        }
        if (null != exception) {
            throw exception;
        }
        return deletedFilesCount;
    }

    public static int forceDelete(File file) throws IOException {
        int deletedFilesCount;
        if (file.isDirectory()) {
            deletedFilesCount = FileUtils.deleteDirectory(file);
        } else {
            boolean filePresent = file.exists();
            if (file.delete()) {
                deletedFilesCount = 1;
            } else {
                if (!filePresent) {
                    throw new FileNotFoundException("File does not exist: " + file);
                }
                String message = "Unable to delete file: " + file;
                throw new IOException(message);
            }
        }
        return deletedFilesCount;
    }

    public static void forceDeleteOnExit(File file) {
        if (file.isDirectory()) {
            FileUtils.deleteDirectoryOnExit(file);
        } else {
            file.deleteOnExit();
        }
    }

    public static void deleteDirectoryOnExit(File directory) {
        if (!directory.exists()) {
            return;
        }
        directory.deleteOnExit();
        if (!FileUtils.isSymlink(directory)) {
            FileUtils.cleanDirectoryOnExit(directory);
        }
    }

    private static void cleanDirectoryOnExit(File directory) {
        for (File file : FileUtils.listFiles(directory)) {
            FileUtils.forceDeleteOnExit(file);
        }
    }

    public static File[] listFiles(File directory) {
        if (directory == null || !directory.exists() || !directory.isDirectory()) {
            return EMPTY_FILE_ARRAY;
        }
        File[] files = directory.listFiles();
        if (ArrayUtils.isEmpty(files)) {
            files = EMPTY_FILE_ARRAY;
        }
        return files;
    }

    public static boolean isSymlink(File file) {
        return Files.isSymbolicLink(file.toPath());
    }

    public static final File getCanonicalFile(File file) {
        return ThrowableSupplier.execute(file::getCanonicalFile);
    }

    private FileUtils() {
    }
}

