/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io;

import io.microsphere.collection.ListUtils;
import io.microsphere.io.Serializer;
import io.microsphere.reflect.TypeUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ServiceLoaderUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class Serializers {
    private final Map<Class<?>, List<Serializer>> typedSerializers = new HashMap();
    private final ClassLoader classLoader;

    public Serializers(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public Serializers() {
        this(ClassLoaderUtils.getDefaultClassLoader());
    }

    public void loadSPI() {
        for (Serializer serializer : ServiceLoaderUtils.loadServicesList(Serializer.class, this.classLoader)) {
            List<Class<?>> typeArguments = TypeUtils.resolveTypeArgumentClasses(serializer.getClass());
            Class<?> targetClass = ListUtils.first(typeArguments);
            List serializers = this.typedSerializers.computeIfAbsent(targetClass, k -> new LinkedList());
            serializers.add(serializer);
        }
    }

    public Serializer<?> getMostCompatible(Class<?> serializedType) {
        Serializer<Object> serializer = this.getHighestPriority(serializedType);
        if (serializer == null) {
            serializer = this.getLowestPriority(Object.class);
        }
        return serializer;
    }

    public <S> Serializer<S> getHighestPriority(Class<S> serializedType) {
        List<Serializer<S>> serializers = this.get(serializedType);
        return ListUtils.first(serializers);
    }

    public <S> Serializer<S> getLowestPriority(Class<S> serializedType) {
        List<Serializer<S>> serializers = this.get(serializedType);
        return ListUtils.last(serializers);
    }

    public <S> List<Serializer<S>> get(Class<S> serializedType) {
        return this.typedSerializers.getOrDefault(serializedType, Collections.emptyList());
    }
}

