/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io;

import io.microsphere.annotation.Nonnull;
import io.microsphere.collection.MapUtils;
import io.microsphere.concurrent.CustomizedThreadFactory;
import io.microsphere.concurrent.ExecutorUtils;
import io.microsphere.event.EventDispatcher;
import io.microsphere.io.FileWatchService;
import io.microsphere.io.event.FileChangedEvent;
import io.microsphere.io.event.FileChangedListener;
import io.microsphere.util.ArrayUtils;
import java.io.File;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.Watchable;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class StandardFileWatchService
implements FileWatchService,
AutoCloseable {
    public static final String DEFAULT_THREAD_NAME_PREFIX = "microsphere-file-watch-service";
    public static final String THREAD_NAME_PREFIX_PROPERTY_NAME = "microsphere.file-watch-service.thread-name-prefix";
    public static final String THREAD_NAME_PREFIX = System.getProperty("microsphere.file-watch-service.thread-name-prefix", "microsphere-file-watch-service");
    private static final WatchEvent.Kind<?>[] ALL_WATCH_EVENT_KINDS = new WatchEvent.Kind[]{StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE, StandardWatchEventKinds.ENTRY_MODIFY};
    private WatchService watchService;
    private final ExecutorService eventLoopExecutor;
    private final Executor eventHandlerExecutor;
    private final Map<Path, FileChangedMetadata> fileChangedMetadataCache = MapUtils.newTreeMap();
    private volatile boolean started;
    private Future eventLoopFuture;

    public StandardFileWatchService() {
        this(EventDispatcher.DIRECT_EXECUTOR);
    }

    public StandardFileWatchService(Executor eventHandlerExecutor) {
        this(eventHandlerExecutor, Executors.newSingleThreadExecutor(CustomizedThreadFactory.newThreadFactory(THREAD_NAME_PREFIX, true)));
    }

    public StandardFileWatchService(Executor eventHandlerExecutor, ExecutorService eventLoopExecutor) {
        this.eventLoopExecutor = eventLoopExecutor;
        this.eventHandlerExecutor = eventHandlerExecutor;
        ExecutorUtils.shutdownOnExit(eventLoopExecutor, eventHandlerExecutor);
    }

    public void start() throws Exception {
        if (this.started) {
            throw new IllegalStateException("StandardFileWatchService has started");
        }
        this.started = true;
        FileSystem fileSystem = FileSystems.getDefault();
        WatchService watchService = fileSystem.newWatchService();
        this.registerDirectoriesToWatchService(watchService);
        this.dispatchFileChangedEvents(watchService);
        this.watchService = watchService;
    }

    private void dispatchFileChangedEvents(WatchService watchService) {
        this.eventLoopFuture = this.eventLoopExecutor.submit(() -> {
            while (this.started) {
                WatchKey watchKey = null;
                try {
                    watchKey = watchService.take();
                    if (!watchKey.isValid()) continue;
                    for (WatchEvent<?> event : watchKey.pollEvents()) {
                        Watchable watchable = watchKey.watchable();
                        Path dirPath = (Path)watchable;
                        Path fileRelativePath = (Path)event.context();
                        FileChangedMetadata metadata = this.fileChangedMetadataCache.get(dirPath);
                        if (metadata == null) continue;
                        Path filePath = dirPath.resolve(fileRelativePath);
                        if (!Files.isDirectory(dirPath, LinkOption.NOFOLLOW_LINKS) && !metadata.filePaths.contains(filePath)) continue;
                        EventDispatcher eventDispatcher = metadata.eventDispatcher;
                        WatchEvent.Kind<?> watchEventKind = event.kind();
                        this.dispatchFileChangedEvent(filePath, watchEventKind, eventDispatcher);
                    }
                }
                finally {
                    if (watchKey == null) continue;
                    watchKey.reset();
                }
            }
            return null;
        });
    }

    private void dispatchFileChangedEvent(Path filePath, WatchEvent.Kind watchEventKind, EventDispatcher eventDispatcher) {
        File file = filePath.toFile();
        FileChangedEvent.Kind kind = this.toKind(watchEventKind);
        FileChangedEvent fileChangedEvent = new FileChangedEvent(file, kind);
        eventDispatcher.dispatch(fileChangedEvent);
    }

    private void registerDirectoriesToWatchService(WatchService watchService) throws Exception {
        for (Map.Entry<Path, FileChangedMetadata> entry : this.fileChangedMetadataCache.entrySet()) {
            Path directoryPath = entry.getKey();
            FileChangedMetadata metadata = entry.getValue();
            WatchEvent.Kind[] kinds = metadata.watchEventKinds;
            directoryPath.register(watchService, kinds);
        }
    }

    @Override
    public void watch(File file, FileChangedListener listener, FileChangedEvent.Kind ... kinds) {
        Path filePath = file.toPath();
        FileChangedMetadata metadata = this.getMetadata(filePath, kinds);
        metadata.filePaths.add(filePath);
        metadata.eventDispatcher.addEventListener(listener);
    }

    private FileChangedMetadata getMetadata(Path filePath, FileChangedEvent.Kind ... kinds) {
        Path dirPath = Files.isDirectory(filePath, LinkOption.NOFOLLOW_LINKS) ? filePath : filePath.getParent();
        return this.fileChangedMetadataCache.computeIfAbsent(dirPath, k -> {
            FileChangedMetadata metadata = new FileChangedMetadata();
            metadata.eventDispatcher = EventDispatcher.parallel(this.eventHandlerExecutor);
            FileChangedMetadata.access$002(metadata, this.toWatchEventKinds(kinds));
            return metadata;
        });
    }

    @Nonnull
    private WatchEvent.Kind<?>[] toWatchEventKinds(FileChangedEvent.Kind[] kinds) {
        int size = ArrayUtils.length(kinds);
        if (size < 1) {
            return ALL_WATCH_EVENT_KINDS;
        }
        WatchEvent.Kind[] watchEventKinds = new WatchEvent.Kind[size];
        for (int i = 0; i < size; ++i) {
            FileChangedEvent.Kind kind = kinds[i];
            watchEventKinds[i] = this.toWatchEventKind(kind);
        }
        return watchEventKinds;
    }

    @Nonnull
    private WatchEvent.Kind<?> toWatchEventKind(FileChangedEvent.Kind kind) {
        WatchEvent.Kind<Object> watchEventKind = StandardWatchEventKinds.OVERFLOW;
        switch (kind) {
            case CREATED: {
                watchEventKind = StandardWatchEventKinds.ENTRY_CREATE;
                break;
            }
            case MODIFIED: {
                watchEventKind = StandardWatchEventKinds.ENTRY_MODIFY;
                break;
            }
            case DELETED: {
                watchEventKind = StandardWatchEventKinds.ENTRY_DELETE;
            }
        }
        return watchEventKind;
    }

    @Nonnull
    private FileChangedEvent.Kind toKind(WatchEvent.Kind<?> watchEventKind) {
        FileChangedEvent.Kind kind = StandardWatchEventKinds.ENTRY_CREATE.equals(watchEventKind) ? FileChangedEvent.Kind.CREATED : (StandardWatchEventKinds.ENTRY_MODIFY.equals(watchEventKind) ? FileChangedEvent.Kind.MODIFIED : FileChangedEvent.Kind.DELETED);
        return kind;
    }

    public void stop() throws Exception {
        if (this.started) {
            this.started = false;
            if (!this.eventLoopExecutor.awaitTermination(100L, TimeUnit.MILLISECONDS)) {
                this.eventLoopFuture.cancel(true);
            }
            if (this.watchService != null) {
                this.watchService.close();
            }
            this.fileChangedMetadataCache.clear();
            ExecutorUtils.shutdown(this.eventLoopExecutor);
            ExecutorUtils.shutdown(this.eventHandlerExecutor);
        }
    }

    @Override
    public void close() throws Exception {
        this.stop();
    }

    private static class FileChangedMetadata {
        private final Set<Path> filePaths = new TreeSet<Path>();
        private EventDispatcher eventDispatcher;
        private WatchEvent.Kind<?>[] watchEventKinds;

        private FileChangedMetadata() {
        }

        static /* synthetic */ WatchEvent.Kind[] access$002(FileChangedMetadata x0, WatchEvent.Kind[] x1) {
            x0.watchEventKinds = x1;
            return x1;
        }
    }
}

