/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io.event;

import io.microsphere.event.EventListener;
import io.microsphere.io.event.FileChangedEvent;

public interface FileChangedListener
extends EventListener<FileChangedEvent> {
    @Override
    default public void onEvent(FileChangedEvent event) {
        FileChangedEvent.Kind kind = event.getKind();
        switch (kind) {
            case CREATED: {
                this.onFileCreated(event);
                break;
            }
            case MODIFIED: {
                this.onFileModified(event);
                break;
            }
            case DELETED: {
                this.onFileDeleted(event);
            }
        }
    }

    default public void onFileCreated(FileChangedEvent event) {
    }

    default public void onFileModified(FileChangedEvent event) {
    }

    default public void onFileDeleted(FileChangedEvent event) {
    }
}

