/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io.filter;

import io.microsphere.io.FileUtils;
import io.microsphere.io.filter.IOFileFilter;
import io.microsphere.util.StringUtils;
import io.microsphere.util.SystemUtils;
import java.io.File;

public class FileExtensionFilter
implements IOFileFilter {
    private final String extension;

    protected FileExtensionFilter(String extension) {
        int lastIndex = extension.lastIndexOf(".");
        this.extension = lastIndex > -1 ? extension.substring(lastIndex + 1) : extension;
    }

    @Override
    public boolean accept(File file) {
        if (file == null || file.isDirectory()) {
            return false;
        }
        String fileName = file.getName();
        String fileExtension = FileUtils.getFileExtension(fileName);
        if (StringUtils.isBlank(fileExtension)) {
            return false;
        }
        return SystemUtils.IS_OS_WINDOWS ? fileExtension.equalsIgnoreCase(this.extension) : fileExtension.equals(this.extension);
    }

    public static FileExtensionFilter of(String extension) {
        return new FileExtensionFilter(extension);
    }
}

