/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.io.scanner;

import io.microsphere.filter.FilterUtils;
import io.microsphere.filter.PackageNameClassNameFilter;
import io.microsphere.lang.ClassDataRepository;
import io.microsphere.lang.function.Streams;
import io.microsphere.net.URLUtils;
import io.microsphere.util.ClassLoaderUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.StringUtils;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.function.Predicate;

public class SimpleClassScanner {
    public static final SimpleClassScanner INSTANCE = new SimpleClassScanner();

    public Set<Class<?>> scan(ClassLoader classLoader, String packageName) throws IllegalArgumentException, IllegalStateException {
        return this.scan(classLoader, packageName, false);
    }

    public Set<Class<?>> scan(ClassLoader classLoader, String packageName, boolean recursive) throws IllegalArgumentException, IllegalStateException {
        return this.scan(classLoader, packageName, recursive, false);
    }

    public Set<Class<?>> scan(ClassLoader classLoader, String packageName, boolean recursive, boolean requiredLoad) throws IllegalArgumentException, IllegalStateException {
        LinkedHashSet classesSet = new LinkedHashSet();
        String packageResourceName = ClassLoaderUtils.ResourceType.PACKAGE.resolve(packageName);
        try {
            ClassDataRepository repository;
            ArrayList<String> classNamesInPackage;
            LinkedHashSet<String> classNames = new LinkedHashSet<String>();
            Set<URL> resourceURLs = ClassLoaderUtils.getResources(classLoader, ClassLoaderUtils.ResourceType.PACKAGE, packageName);
            if (resourceURLs.isEmpty() && !(classNamesInPackage = new ArrayList<String>((repository = ClassDataRepository.INSTANCE).getClassNamesInPackage(packageName))).isEmpty()) {
                String classPath = repository.findClassPath((String)classNamesInPackage.get(0));
                URL resourceURL = new File(classPath).toURI().toURL();
                resourceURLs = new HashSet<URL>();
                resourceURLs.add(resourceURL);
            }
            for (URL resourceURL : resourceURLs) {
                URL classPathURL = this.resolveClassPathURL(resourceURL, packageResourceName);
                String classPath = classPathURL.getFile();
                Set<String> classNamesInClassPath = ClassUtils.findClassNamesInClassPath(classPath, true);
                classNames.addAll(this.filterClassNames(classNamesInClassPath, packageName, recursive));
            }
            for (String className : classNames) {
                Class<?> class_ = requiredLoad ? ClassLoaderUtils.loadClass(classLoader, className) : ClassLoaderUtils.findLoadedClass(classLoader, className);
                if (class_ == null) continue;
                classesSet.add(class_);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return Collections.unmodifiableSet(classesSet);
    }

    public Set<Class<?>> scan(ClassLoader classLoader, URL resourceInArchive, boolean requiredLoad, Predicate<? super Class<?>> ... classFilters) {
        File archiveFile = URLUtils.resolveArchiveFile(resourceInArchive);
        return this.scan(classLoader, archiveFile, requiredLoad, classFilters);
    }

    public Set<Class<?>> scan(ClassLoader classLoader, File archiveFile, boolean requiredLoad, Predicate<? super Class<?>> ... classFilters) {
        Set<String> classNames = ClassUtils.findClassNamesInClassPath(archiveFile, true);
        LinkedHashSet classesSet = new LinkedHashSet();
        for (String className : classNames) {
            Class<?> class_ = requiredLoad ? ClassLoaderUtils.loadClass(classLoader, className) : ClassLoaderUtils.findLoadedClass(classLoader, className);
            if (class_ == null) continue;
            classesSet.add(class_);
        }
        return Streams.filterAll(classesSet, classFilters);
    }

    private Set<String> filterClassNames(Set<String> classNames, String packageName, boolean recursive) {
        PackageNameClassNameFilter packageNameClassNameFilter = new PackageNameClassNameFilter(packageName, recursive);
        LinkedHashSet<String> filterClassNames = new LinkedHashSet<String>(FilterUtils.filter(classNames, packageNameClassNameFilter));
        return filterClassNames;
    }

    private URL resolveClassPathURL(URL resourceURL, String packageResourceName) {
        String resource = resourceURL.toExternalForm();
        String classPath = StringUtils.substringBefore(resource, packageResourceName);
        return URLUtils.ofURL(classPath);
    }
}

