/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.json;

import io.microsphere.collection.ListUtils;
import io.microsphere.util.StringUtils;
import io.microsphere.util.Utils;
import java.lang.reflect.Array;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Set;

public abstract class JSONUtils
implements Utils {
    public static void append(StringBuilder jsonBuilder, String name, boolean value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, byte value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, short value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, int value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, long value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, float value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, double value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, char value) {
        JSONUtils.appendName(jsonBuilder, name).append('\"').append(value).append('\"');
    }

    public static void append(StringBuilder jsonBuilder, String name, Boolean value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Byte value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Short value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Integer value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Long value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Float value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Double value) {
        JSONUtils.appendName(jsonBuilder, name).append(value);
    }

    public static void append(StringBuilder jsonBuilder, String name, Character value) {
        JSONUtils.appendName(jsonBuilder, name).append('\"').append(value).append('\"');
    }

    public static void append(StringBuilder jsonBuilder, String name, String value) {
        JSONUtils.appendName(jsonBuilder, name).append('\"').append(value).append('\"');
    }

    public static void append(StringBuilder jsonBuilder, String name, Type value) {
        JSONUtils.append(jsonBuilder, name, value.getTypeName());
    }

    public static void append(StringBuilder jsonBuilder, String name, Object value) {
        JSONUtils.appendName(jsonBuilder, name);
        JSONUtils.appendValue(jsonBuilder, value);
    }

    public static void append(StringBuilder jsonBuilder, String name, boolean[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, byte[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, short[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, int[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, long[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, float[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, double[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, char[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append('\"').append(values[i]).append('\"');
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, String[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append('\"').append(values[i]).append('\"');
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Boolean[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Byte[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Short[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Integer[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Long[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Float[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Double[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append(values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void append(StringBuilder jsonBuilder, String name, Character[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            jsonBuilder.append('\"').append(values[i]).append('\"');
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static <T> void append(StringBuilder jsonBuilder, String name, T[] values) {
        JSONUtils.appendName(jsonBuilder, name);
        jsonBuilder.append('[');
        for (int i = 0; i < values.length; ++i) {
            JSONUtils.appendValue(jsonBuilder, values[i]);
            if (i >= values.length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static void appendValue(StringBuilder jsonBuilder, Object value) {
        Class<?> valueClass = value.getClass();
        if (valueClass.isArray()) {
            JSONUtils.appendArray(jsonBuilder, value);
        } else if (Map.class.isAssignableFrom(valueClass)) {
            JSONUtils.appendMap(jsonBuilder, (Map)value);
        } else if (Iterable.class.isAssignableFrom(valueClass)) {
            JSONUtils.appendIterable(jsonBuilder, (Iterable)value);
        } else if (Character.class == valueClass || CharSequence.class.isAssignableFrom(valueClass) || Enum.class.isAssignableFrom(valueClass)) {
            JSONUtils.appendString(jsonBuilder, value);
        } else if (Type.class.isAssignableFrom(valueClass)) {
            JSONUtils.appendType(jsonBuilder, (Type)value);
        } else {
            jsonBuilder.append(value);
        }
    }

    static void appendArray(StringBuilder jsonBuilder, Object value) {
        jsonBuilder.append('[');
        int length = Array.getLength(value);
        for (int i = 0; i < length; ++i) {
            JSONUtils.appendValue(jsonBuilder, Array.get(value, i));
            if (i >= length - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    public static StringBuilder appendName(StringBuilder jsonBuilder, String name) {
        if (StringUtils.isNotBlank(name)) {
            jsonBuilder.append('\"').append(name).append('\"').append(':');
        }
        return jsonBuilder;
    }

    static void appendMap(StringBuilder jsonBuilder, Map<String, Object> map) {
        jsonBuilder.append('{');
        Set<Map.Entry<String, Object>> entrySet = map.entrySet();
        int i = 0;
        int size = entrySet.size();
        for (Map.Entry<String, Object> entry : entrySet) {
            String name = entry.getKey();
            Object value = entry.getValue();
            JSONUtils.append(jsonBuilder, name, value);
            if (i++ >= size - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append('}');
    }

    static void appendIterable(StringBuilder jsonBuilder, Iterable<?> values) {
        jsonBuilder.append('[');
        List<?> list = ListUtils.ofList(values);
        int size = list.size();
        for (int i = 0; i < size; ++i) {
            JSONUtils.appendValue(jsonBuilder, list.get(i));
            if (i >= size - 1) continue;
            jsonBuilder.append(',');
        }
        jsonBuilder.append(']');
    }

    static void appendString(StringBuilder jsonBuilder, Object value) {
        jsonBuilder.append('\"').append(value).append('\"');
    }

    static void appendType(StringBuilder jsonBuilder, Type value) {
        JSONUtils.appendString(jsonBuilder, value.getTypeName());
    }

    private JSONUtils() {
    }
}

