/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.lang;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.CollectionUtils;
import io.microsphere.util.ClassPathUtils;
import io.microsphere.util.ClassUtils;
import io.microsphere.util.StringUtils;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;

public class ClassDataRepository {
    public static final ClassDataRepository INSTANCE = new ClassDataRepository();
    private final Map<String, Set<String>> classPathToClassNamesMap = this.initClassPathToClassNamesMap();
    private final Map<String, String> classNameToClassPathsMap = this.initClassNameToClassPathsMap();
    private final Map<String, Set<String>> packageNameToClassNamesMap = this.initPackageNameToClassNamesMap();

    private ClassDataRepository() {
    }

    @Nonnull
    public Set<String> getAllPackageNamesInClassPaths() {
        return this.packageNameToClassNamesMap.keySet();
    }

    @Nullable
    public String findClassPath(Class<?> type) {
        return this.findClassPath(type.getName());
    }

    @Nullable
    public String findClassPath(String className) {
        return this.classNameToClassPathsMap.get(className);
    }

    @Nonnull
    public Set<String> getClassNamesInClassPath(String classPath, boolean recursive) {
        Set<String> classNames = this.classPathToClassNamesMap.get(classPath);
        if (CollectionUtils.isEmpty(classNames)) {
            classNames = ClassUtils.findClassNamesInClassPath(classPath, recursive);
        }
        return classNames;
    }

    @Nonnull
    public Set<String> getClassNamesInPackage(Package onePackage) {
        return this.getClassNamesInPackage(onePackage.getName());
    }

    @Nonnull
    public Set<String> getClassNamesInPackage(String packageName) {
        Set<String> classNames = this.packageNameToClassNamesMap.get(packageName);
        return classNames == null ? Collections.emptySet() : classNames;
    }

    @Nonnull
    public Map<String, Set<String>> getClassPathToClassNamesMap() {
        return this.classPathToClassNamesMap;
    }

    @Nonnull
    public Set<String> getAllClassNamesInClassPaths() {
        LinkedHashSet<String> allClassNames = new LinkedHashSet<String>();
        for (Set<String> classNames : this.classPathToClassNamesMap.values()) {
            allClassNames.addAll(classNames);
        }
        return Collections.unmodifiableSet(allClassNames);
    }

    public URL getCodeSourceLocation(Class<?> type) throws NullPointerException {
        URL codeSourceLocation = null;
        ClassLoader classLoader = type.getClassLoader();
        if (classLoader == null) {
            String path = this.findClassPath(type);
            if (StringUtils.isNotBlank(path)) {
                try {
                    codeSourceLocation = new File(path).toURI().toURL();
                }
                catch (MalformedURLException ignored) {
                    codeSourceLocation = null;
                }
            }
        } else {
            ProtectionDomain protectionDomain = type.getProtectionDomain();
            CodeSource codeSource = protectionDomain == null ? null : protectionDomain.getCodeSource();
            codeSourceLocation = codeSource == null ? null : codeSource.getLocation();
        }
        return codeSourceLocation;
    }

    private Map<String, Set<String>> initClassPathToClassNamesMap() {
        LinkedHashMap<String, Set<String>> classPathToClassNamesMap = new LinkedHashMap<String, Set<String>>();
        LinkedHashSet<String> classPaths = new LinkedHashSet<String>();
        classPaths.addAll(ClassPathUtils.getBootstrapClassPaths());
        classPaths.addAll(ClassPathUtils.getClassPaths());
        for (String classPath : classPaths) {
            Set<String> classNames = ClassUtils.findClassNamesInClassPath(classPath, true);
            classPathToClassNamesMap.put(classPath, classNames);
        }
        return Collections.unmodifiableMap(classPathToClassNamesMap);
    }

    private Map<String, String> initClassNameToClassPathsMap() {
        LinkedHashMap<String, String> classNameToClassPathsMap = new LinkedHashMap<String, String>();
        for (Map.Entry<String, Set<String>> entry : this.classPathToClassNamesMap.entrySet()) {
            String classPath = entry.getKey();
            Set<String> classNames = entry.getValue();
            for (String className : classNames) {
                classNameToClassPathsMap.put(className, classPath);
            }
        }
        return Collections.unmodifiableMap(classNameToClassPathsMap);
    }

    private Map<String, Set<String>> initPackageNameToClassNamesMap() {
        LinkedHashMap<String, LinkedHashSet<String>> packageNameToClassNamesMap = new LinkedHashMap<String, LinkedHashSet<String>>();
        for (Map.Entry<String, String> entry : this.classNameToClassPathsMap.entrySet()) {
            String className = entry.getKey();
            String packageName = ClassUtils.resolvePackageName(className);
            LinkedHashSet<String> classNamesInPackage = (LinkedHashSet<String>)packageNameToClassNamesMap.get(packageName);
            if (classNamesInPackage == null) {
                classNamesInPackage = new LinkedHashSet<String>();
                packageNameToClassNamesMap.put(packageName, classNamesInPackage);
            }
            classNamesInPackage.add(className);
        }
        return Collections.unmodifiableMap(packageNameToClassNamesMap);
    }
}

