/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.lang.function;

import io.microsphere.annotation.Nonnull;
import io.microsphere.util.ArrayUtils;
import java.util.function.Predicate;

public interface Predicates {
    public static final Predicate[] EMPTY_PREDICATE_ARRAY = new Predicate[0];

    @Nonnull
    public static <T> Predicate<T>[] emptyArray() {
        return EMPTY_PREDICATE_ARRAY;
    }

    @Nonnull
    public static <T> Predicate<T> alwaysTrue() {
        return e -> true;
    }

    @Nonnull
    public static <T> Predicate<T> alwaysFalse() {
        return e -> false;
    }

    @Nonnull
    public static <T> Predicate<? super T> and(Predicate<? super T> ... predicates) {
        int length = ArrayUtils.length(predicates);
        if (length == 0) {
            return Predicates.alwaysTrue();
        }
        if (length == 1) {
            return predicates[0];
        }
        Predicate<? super T> andPredicate = Predicates.alwaysTrue();
        for (Predicate<? super T> p : predicates) {
            andPredicate = andPredicate.and(p);
        }
        return andPredicate;
    }

    @Nonnull
    public static <T> Predicate<? super T> or(Predicate<? super T> ... predicates) {
        int length = ArrayUtils.length(predicates);
        if (length == 0) {
            return Predicates.alwaysTrue();
        }
        if (length == 1) {
            return predicates[0];
        }
        Predicate<? super T> orPredicate = Predicates.alwaysFalse();
        for (Predicate<? super T> p : predicates) {
            orPredicate = orPredicate.or(p);
        }
        return orPredicate;
    }
}

