/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.lang.function;

import io.microsphere.util.Assert;
import java.util.function.Consumer;

@FunctionalInterface
public interface ThrowableAction {
    public void execute() throws Throwable;

    default public void execute(Consumer<Throwable> exceptionHandler) {
        Assert.assertNotNull(exceptionHandler, () -> "The 'exceptionHandler' must not be null");
        try {
            this.execute();
        }
        catch (Throwable e) {
            exceptionHandler.accept(e);
        }
    }

    default public void handleException(Throwable failure) {
        throw new RuntimeException(failure);
    }

    public static void execute(ThrowableAction action) {
        ThrowableAction.execute(action, action::handleException);
    }

    public static void execute(ThrowableAction action, Consumer<Throwable> exceptionHandler) throws NullPointerException {
        Assert.assertNotNull((Object)action, () -> "The 'action' must not be null");
        action.execute(exceptionHandler);
    }
}

