/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.lang.function;

import io.microsphere.text.FormatUtils;
import io.microsphere.util.Assert;

@FunctionalInterface
public interface ThrowableBiFunction<T, U, R> {
    public static final ExceptionHandler DEFAULT_EXCEPTION_HANDLER = (first, second, failure) -> {
        String errorMessage = FormatUtils.format("It's failed to execute the function with arguments[{}, {}] is failed", first, second);
        throw new RuntimeException(errorMessage, failure);
    };

    public R apply(T var1, U var2) throws Throwable;

    public static <T, U, R> R execute(T first, U second, ThrowableBiFunction<T, U, R> function) throws NullPointerException {
        return ThrowableBiFunction.execute(first, second, function, DEFAULT_EXCEPTION_HANDLER);
    }

    public static <T, U, R> R execute(T first, U second, ThrowableBiFunction<T, U, R> function, ExceptionHandler<T, U, R> exceptionHandler) throws NullPointerException {
        R result;
        Assert.assertNotNull(function, () -> "The 'function' must not be null");
        Assert.assertNotNull(exceptionHandler, () -> "The 'exceptionHandler' must not be null");
        try {
            result = function.apply(first, second);
        }
        catch (Throwable failure) {
            result = exceptionHandler.handle(first, second, failure);
        }
        return result;
    }

    public static interface ExceptionHandler<T, U, R> {
        public R handle(T var1, U var2, Throwable var3);
    }
}

