/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.lang.function;

import io.microsphere.util.Assert;
import java.util.function.BiFunction;

@FunctionalInterface
public interface ThrowableFunction<T, R> {
    public R apply(T var1) throws Throwable;

    default public R execute(T t) throws RuntimeException {
        return (R)this.execute(t, this::handleException);
    }

    default public R execute(T t, BiFunction<T, Throwable, R> exceptionHandler) throws RuntimeException {
        R result;
        try {
            result = this.apply(t);
        }
        catch (Throwable e) {
            result = exceptionHandler.apply(t, e);
        }
        return result;
    }

    default public R handleException(T t, Throwable failure) {
        throw new RuntimeException(failure);
    }

    default public <V> ThrowableFunction<V, R> compose(ThrowableFunction<? super V, ? extends T> before) {
        Assert.assertNotNull(before, () -> "The 'before' must not be null");
        return v -> this.apply(before.apply((Object)v));
    }

    default public <V> ThrowableFunction<T, V> andThen(ThrowableFunction<? super R, ? extends V> after) {
        Assert.assertNotNull(after, () -> "The 'after' must not be null");
        return t -> after.apply((R)this.apply(t));
    }

    public static <T, R> R execute(T t, ThrowableFunction<T, R> function) throws IllegalArgumentException {
        return (R)ThrowableFunction.execute(t, function, function::handleException);
    }

    public static <T, R> R execute(T t, ThrowableFunction<T, R> function, BiFunction<T, Throwable, R> exceptionHandler) throws IllegalArgumentException {
        Assert.assertNotNull(function, () -> "The 'function' must not be null");
        Assert.assertNotNull(exceptionHandler, "The 'exceptionHandler' must not be null");
        return function.execute(t, exceptionHandler);
    }
}

