/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.lang.function;

import io.microsphere.util.Assert;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowableSupplier<T> {
    public T get() throws Throwable;

    default public T execute() {
        return (T)this.execute(this::handleException);
    }

    default public T execute(Function<Throwable, T> exceptionHandler) {
        T result;
        Assert.assertNotNull(exceptionHandler, () -> "The 'exceptionHandler' must not be null");
        try {
            result = this.get();
        }
        catch (Throwable e) {
            result = exceptionHandler.apply(e);
        }
        return result;
    }

    default public T handleException(Throwable failure) {
        throw new RuntimeException(failure);
    }

    public static <T> T execute(ThrowableSupplier<T> supplier) throws NullPointerException {
        return (T)ThrowableSupplier.execute(supplier, supplier::handleException);
    }

    public static <T> T execute(ThrowableSupplier<T> supplier, Function<Throwable, T> exceptionHandler) throws NullPointerException {
        Assert.assertNotNull(supplier, "The supplier must not be null");
        return supplier.execute(exceptionHandler);
    }
}

