/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.logging;

import io.microsphere.logging.AbstractLogger;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ACLLoggerFactory
extends LoggerFactory {
    public static final String ACL_LOG_CLASS_NAME = "org.apache.commons.logging.Log";

    @Override
    protected String getDelegateLoggerClassName() {
        return ACL_LOG_CLASS_NAME;
    }

    @Override
    public Logger createLogger(String name) {
        return new ACLLogger(name);
    }

    @Override
    public int getPriority() {
        return 5;
    }

    static class ACLLogger
    extends AbstractLogger {
        private final Log logger;

        ACLLogger(String name) {
            super(name);
            this.logger = LogFactory.getLog((String)name);
        }

        @Override
        public boolean isTraceEnabled() {
            return this.logger.isTraceEnabled();
        }

        @Override
        public void trace(String message) {
            this.logger.trace((Object)message);
        }

        @Override
        public void trace(String message, Throwable t) {
            this.logger.trace((Object)message, t);
        }

        @Override
        public boolean isDebugEnabled() {
            return this.logger.isDebugEnabled();
        }

        @Override
        public void debug(String message) {
            this.logger.debug((Object)message);
        }

        @Override
        public void debug(String message, Throwable t) {
            this.logger.debug((Object)message, t);
        }

        @Override
        public boolean isInfoEnabled() {
            return this.logger.isInfoEnabled();
        }

        @Override
        public void info(String message) {
            this.logger.info((Object)message);
        }

        @Override
        public void info(String message, Throwable t) {
            this.logger.info((Object)message, t);
        }

        @Override
        public boolean isWarnEnabled() {
            return this.logger.isWarnEnabled();
        }

        @Override
        public void warn(String message) {
            this.logger.warn((Object)message);
        }

        @Override
        public void warn(String message, Throwable t) {
            this.logger.warn((Object)message, t);
        }

        @Override
        public boolean isErrorEnabled() {
            return this.logger.isErrorEnabled();
        }

        @Override
        public void error(String message) {
            this.logger.error((Object)message);
        }

        @Override
        public void error(String message, Throwable t) {
            this.logger.error((Object)message, t);
        }
    }
}

