/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.logging;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.ListUtils;
import io.microsphere.lang.Prioritized;
import io.microsphere.logging.Logger;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.ServiceLoader;

public abstract class LoggerFactory
implements Prioritized {
    private static final ClassLoader classLoader = LoggerFactory.class.getClassLoader();
    @Nullable
    private static final LoggerFactory factory = LoggerFactory.loadFactory();

    @Nullable
    private static LoggerFactory loadFactory() {
        List<LoggerFactory> availableFactories = LoggerFactory.loadAvailableFactories();
        return availableFactories.get(0);
    }

    static List<LoggerFactory> loadAvailableFactories() {
        List<LoggerFactory> factories = LoggerFactory.loadFactories();
        factories.removeIf(factory -> !factory.isAvailable());
        return factories;
    }

    static List<LoggerFactory> loadFactories() {
        LinkedList<LoggerFactory> factories = ListUtils.newLinkedList(ServiceLoader.load(LoggerFactory.class, classLoader));
        Collections.sort(factories, Prioritized.COMPARATOR);
        return factories;
    }

    @Nonnull
    public static Logger getLogger(Class<?> type) {
        return LoggerFactory.getLogger(type.getName());
    }

    @Nonnull
    public static Logger getLogger(String name) {
        return factory.createLogger(name);
    }

    protected boolean isAvailable() {
        return this.getDelegateLoggerClass() != null;
    }

    private Class<?> getDelegateLoggerClass() {
        String className = this.getDelegateLoggerClassName();
        Class<?> delegateLoggerClass = null;
        try {
            delegateLoggerClass = classLoader.loadClass(className);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return delegateLoggerClass;
    }

    protected abstract String getDelegateLoggerClassName();

    public abstract Logger createLogger(String var1);
}

