/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.management;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import io.microsphere.collection.MapUtils;
import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.management.MBeanAttribute;
import io.microsphere.util.ArrayUtils;
import io.microsphere.util.Utils;
import java.lang.management.ClassLoadingMXBean;
import java.lang.management.CompilationMXBean;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryManagerMXBean;
import java.lang.management.MemoryPoolMXBean;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.lang.management.ThreadMXBean;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class JmxUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(JmxUtils.class);
    public static final MBeanAttribute[] EMPTY_MBEAN_ATTRIBUTE_ARRAY = new MBeanAttribute[0];
    private static ClassLoadingMXBean classLoadingMXBean;
    private static MemoryMXBean memoryMXBean;
    private static ThreadMXBean threadMXBean;
    private static RuntimeMXBean runtimeMXBean;
    private static Optional<CompilationMXBean> compilationMXBean;
    private static OperatingSystemMXBean operatingSystemMXBean;
    private static List<MemoryPoolMXBean> memoryPoolMXBeans;
    private static List<MemoryManagerMXBean> memoryManagerMXBeans;
    private static List<GarbageCollectorMXBean> garbageCollectorMXBeans;

    @Nonnull
    public static ClassLoadingMXBean getClassLoadingMXBean() {
        if (classLoadingMXBean == null) {
            classLoadingMXBean = ManagementFactory.getClassLoadingMXBean();
        }
        return classLoadingMXBean;
    }

    @Nonnull
    public static MemoryMXBean getMemoryMXBean() {
        if (memoryMXBean == null) {
            memoryMXBean = ManagementFactory.getMemoryMXBean();
        }
        return memoryMXBean;
    }

    @Nonnull
    public static ThreadMXBean getThreadMXBean() {
        if (threadMXBean == null) {
            threadMXBean = ManagementFactory.getThreadMXBean();
        }
        return threadMXBean;
    }

    @Nonnull
    public static RuntimeMXBean getRuntimeMXBean() {
        if (runtimeMXBean == null) {
            runtimeMXBean = ManagementFactory.getRuntimeMXBean();
        }
        return runtimeMXBean;
    }

    @Nonnull
    public static Optional<CompilationMXBean> getCompilationMXBean() {
        if (compilationMXBean == null) {
            compilationMXBean = Optional.ofNullable(ManagementFactory.getCompilationMXBean());
        }
        return compilationMXBean;
    }

    @Nonnull
    public static OperatingSystemMXBean getOperatingSystemMXBean() {
        if (operatingSystemMXBean == null) {
            operatingSystemMXBean = ManagementFactory.getOperatingSystemMXBean();
        }
        return operatingSystemMXBean;
    }

    @Nonnull
    public static List<MemoryPoolMXBean> getMemoryPoolMXBeans() {
        if (memoryPoolMXBeans == null) {
            memoryPoolMXBeans = Collections.unmodifiableList(ManagementFactory.getMemoryPoolMXBeans());
        }
        return memoryPoolMXBeans;
    }

    @Nonnull
    public static List<MemoryManagerMXBean> getMemoryManagerMXBeans() {
        if (memoryManagerMXBeans == null) {
            memoryManagerMXBeans = Collections.unmodifiableList(ManagementFactory.getMemoryManagerMXBeans());
        }
        return memoryManagerMXBeans;
    }

    @Nonnull
    public static List<GarbageCollectorMXBean> getGarbageCollectorMXBeans() {
        if (garbageCollectorMXBeans == null) {
            garbageCollectorMXBeans = Collections.unmodifiableList(ManagementFactory.getGarbageCollectorMXBeans());
        }
        return garbageCollectorMXBeans;
    }

    @Nonnull
    public static Map<String, MBeanAttribute> getMBeanAttributesMap(MBeanServer mBeanServer, ObjectName objectName) {
        MBeanAttribute[] mBeanAttributes = JmxUtils.getMBeanAttributes(mBeanServer, objectName);
        int length = mBeanAttributes.length;
        if (length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, MBeanAttribute> mBeanAttributesMap = MapUtils.newHashMap(length);
        for (int i = 0; i < length; ++i) {
            MBeanAttribute mBeanAttribute = mBeanAttributes[i];
            String attributeName = mBeanAttribute.getName();
            mBeanAttributesMap.put(attributeName, mBeanAttribute);
        }
        return Collections.unmodifiableMap(mBeanAttributesMap);
    }

    @Nonnull
    public static MBeanAttribute[] getMBeanAttributes(MBeanServer mBeanServer, ObjectName objectName) {
        MBeanInfo mBeanInfo = JmxUtils.getMBeanInfo(mBeanServer, objectName);
        if (mBeanInfo == null) {
            return EMPTY_MBEAN_ATTRIBUTE_ARRAY;
        }
        MBeanAttributeInfo[] attributeInfoList = mBeanInfo.getAttributes();
        int size = attributeInfoList.length;
        MBeanAttribute[] mBeanAttributes = new MBeanAttribute[size];
        for (int i = 0; i < size; ++i) {
            MBeanAttribute mBeanAttribute;
            MBeanAttributeInfo attributeInfo = attributeInfoList[i];
            Object attributeValue = JmxUtils.getAttribute(mBeanServer, objectName, attributeInfo);
            mBeanAttributes[i] = mBeanAttribute = new MBeanAttribute(mBeanInfo, attributeInfo, attributeValue);
        }
        return mBeanAttributes;
    }

    @Nullable
    public static Object getAttribute(MBeanServer mBeanServer, ObjectName objectName, MBeanAttributeInfo attributeInfo) {
        return JmxUtils.doGetAttribute(mBeanServer, objectName, attributeInfo, attributeInfo.getName());
    }

    @Nullable
    public static Object getAttribute(MBeanServer mBeanServer, ObjectName objectName, String attributeName) {
        return JmxUtils.doGetAttribute(mBeanServer, objectName, null, attributeName);
    }

    @Nullable
    public static MBeanAttributeInfo findMBeanAttributeInfo(MBeanServer mBeanServer, ObjectName objectName, String attributeName) {
        MBeanInfo mBeanInfo = JmxUtils.getMBeanInfo(mBeanServer, objectName);
        if (mBeanInfo == null) {
            return null;
        }
        MBeanAttributeInfo targetAttributeInfo = null;
        for (MBeanAttributeInfo attributeInfo : mBeanInfo.getAttributes()) {
            if (!Objects.equals(attributeName, attributeInfo.getName())) continue;
            targetAttributeInfo = attributeInfo;
            break;
        }
        if (targetAttributeInfo == null) {
            JmxUtils.handleAttributeNotFoundException(new AttributeNotFoundException(), mBeanServer, objectName, mBeanInfo, attributeName);
        }
        return targetAttributeInfo;
    }

    public static MBeanInfo getMBeanInfo(MBeanServer mBeanServer, ObjectName objectName) {
        MBeanInfo mBeanInfo = null;
        try {
            mBeanInfo = mBeanServer.getMBeanInfo(objectName);
        }
        catch (InstanceNotFoundException | IntrospectionException | ReflectionException e) {
            JmxUtils.handleException(e, mBeanServer, objectName);
        }
        return mBeanInfo;
    }

    protected static Object doGetAttribute(MBeanServer mBeanServer, ObjectName objectName, @Nullable MBeanAttributeInfo attributeInfo, String attributeName) {
        MBeanAttributeInfo mBeanAttributeInfo = attributeInfo;
        if (mBeanAttributeInfo == null) {
            mBeanAttributeInfo = JmxUtils.findMBeanAttributeInfo(mBeanServer, objectName, attributeName);
        }
        if (mBeanAttributeInfo == null) {
            return null;
        }
        if (!mBeanAttributeInfo.isReadable()) {
            return null;
        }
        Object attributeValue = null;
        try {
            attributeValue = mBeanServer.getAttribute(objectName, attributeName);
        }
        catch (InstanceNotFoundException | ReflectionException e) {
            JmxUtils.handleException(e, mBeanServer, objectName);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
        return attributeValue;
    }

    private static void handleException(Exception e, MBeanServer mBeanServer, ObjectName objectName) {
        if (logger.isWarnEnabled()) {
            logger.warn("the MBean[name : '{}'] can't be manipulated by the Reflection in the MBeanServer[default domain : '{}' , domains : {}]", objectName.getCanonicalName(), mBeanServer.getDefaultDomain(), ArrayUtils.arrayToString(mBeanServer.getDomains()), e);
        }
    }

    private static void handleAttributeNotFoundException(AttributeNotFoundException e, MBeanServer mBeanServer, ObjectName objectName, MBeanInfo mBeanInfo, String attributeName) {
        if (logger.isWarnEnabled()) {
            logger.warn("The attribute[name : '{}' ] of MBean[name : '{}'] can't be found in the MBeanServer[default domain : '{}' , domains : {}]", attributeName, objectName.getCanonicalName(), mBeanServer.getDefaultDomain(), ArrayUtils.arrayToString(mBeanServer.getDomains()), e);
        }
    }

    private JmxUtils() {
    }
}

