/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.management;

import io.microsphere.annotation.Nonnull;
import io.microsphere.annotation.Nullable;
import java.util.Objects;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;

public class MBeanAttribute {
    private final MBeanInfo declaringMBeanInfo;
    private final MBeanAttributeInfo attributeInfo;
    private final Object value;

    public MBeanAttribute(@Nonnull MBeanInfo declaringMBeanInfo, @Nonnull MBeanAttributeInfo attributeInfo, @Nullable Object value) {
        Objects.requireNonNull(declaringMBeanInfo, "The declaring MBeanInfo argument must not be null!");
        Objects.requireNonNull(attributeInfo, "The MBeanAttributeInfo argument must not be null!");
        this.declaringMBeanInfo = declaringMBeanInfo;
        this.attributeInfo = attributeInfo;
        this.value = value;
    }

    @Nonnull
    public MBeanInfo getDeclaringMBeanInfo() {
        return this.declaringMBeanInfo;
    }

    @Nonnull
    public String getName() {
        return this.attributeInfo.getName();
    }

    @Nonnull
    public String getType() {
        return this.attributeInfo.getType();
    }

    public boolean isReadable() {
        return this.attributeInfo.isReadable();
    }

    public boolean isWritable() {
        return this.attributeInfo.isWritable();
    }

    public boolean isIs() {
        return this.attributeInfo.isIs();
    }

    @Nonnull
    public MBeanAttributeInfo getAttributeInfo() {
        return this.attributeInfo;
    }

    public Object getValue() {
        return this.value;
    }
}

