/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.management;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.process.ProcessIdResolver;
import io.microsphere.util.ServiceLoaderUtils;
import io.microsphere.util.Utils;
import java.util.List;

public abstract class ManagementUtils
implements Utils {
    private static final Logger logger = LoggerFactory.getLogger(ManagementUtils.class);
    static final long currentProcessId = ManagementUtils.resolveCurrentProcessId();

    private static long resolveCurrentProcessId() {
        List<ProcessIdResolver> resolvers = ServiceLoaderUtils.loadServicesList(ProcessIdResolver.class);
        Long processId = null;
        for (ProcessIdResolver resolver : resolvers) {
            if (!resolver.supports() || (processId = resolver.current()) == null) continue;
            ManagementUtils.log(resolver, processId);
            break;
        }
        return processId == null ? -1L : processId;
    }

    static void log(ProcessIdResolver resolver, Long processId) {
        if (logger.isTraceEnabled()) {
            logger.trace("The process id was resolved by ProcessIdResolver[class : '{}' , priority : {}] successfully : {}", resolver.getClass().getName(), resolver.getPriority(), processId);
        }
    }

    public static long getCurrentProcessId() {
        return currentProcessId;
    }

    private ManagementUtils() {
    }
}

