/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.net;

import io.microsphere.collection.ListUtils;
import io.microsphere.lang.Prioritized;
import io.microsphere.net.SubProtocolURLConnectionFactory;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class CompositeSubProtocolURLConnectionFactory
implements SubProtocolURLConnectionFactory {
    private final List<SubProtocolURLConnectionFactory> factories;

    public CompositeSubProtocolURLConnectionFactory() {
        this(ListUtils.newLinkedList());
    }

    public CompositeSubProtocolURLConnectionFactory(Iterable<SubProtocolURLConnectionFactory> factories) {
        LinkedList<SubProtocolURLConnectionFactory> newFactories = ListUtils.newLinkedList(factories);
        this.factories = newFactories;
        this.sortFactories();
    }

    public CompositeSubProtocolURLConnectionFactory add(SubProtocolURLConnectionFactory factory) {
        this.addInternal(factory);
        this.sortFactories();
        return this;
    }

    public CompositeSubProtocolURLConnectionFactory add(SubProtocolURLConnectionFactory ... factories) {
        for (int i = 0; i < factories.length; ++i) {
            this.addInternal(factories[i]);
        }
        this.sortFactories();
        return this;
    }

    protected boolean addInternal(SubProtocolURLConnectionFactory factory) {
        if (this.factories.contains(factory)) {
            return false;
        }
        return this.factories.add(factory);
    }

    public boolean remove(SubProtocolURLConnectionFactory factory) {
        boolean result = this.factories.remove(factory);
        if (result) {
            this.sortFactories();
        }
        return result;
    }

    private void sortFactories() {
        List<SubProtocolURLConnectionFactory> factories = this.factories;
        Collections.sort(factories, Prioritized.COMPARATOR);
    }

    @Override
    public boolean supports(URL url, List<String> subProtocols) {
        return this.selectFactoryIndex(url, subProtocols) > -1;
    }

    @Override
    public URLConnection create(URL url, List<String> subProtocols, Proxy proxy) throws IOException {
        SubProtocolURLConnectionFactory factory = this.selectFactory(url, subProtocols);
        return factory.create(url, subProtocols, proxy);
    }

    private SubProtocolURLConnectionFactory selectFactory(URL url, List<String> subProtocols) {
        int index = this.selectFactoryIndex(url, subProtocols);
        return this.factories.get(index);
    }

    private int selectFactoryIndex(URL url, List<String> subProtocols) {
        int index = -1;
        int size = this.factories.size();
        for (int i = 0; i < size; ++i) {
            SubProtocolURLConnectionFactory factory = this.factories.get(i);
            if (!factory.supports(url, subProtocols)) continue;
            index = i;
            break;
        }
        return index;
    }
}

