/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.net;

import io.microsphere.collection.ListUtils;
import io.microsphere.lang.Prioritized;
import java.net.URLStreamHandler;
import java.net.URLStreamHandlerFactory;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;

public class CompositeURLStreamHandlerFactory
implements URLStreamHandlerFactory {
    private final List<URLStreamHandlerFactory> factories;

    public CompositeURLStreamHandlerFactory() {
        this((Collection<URLStreamHandlerFactory>)Collections.emptyList());
    }

    public CompositeURLStreamHandlerFactory(Collection<URLStreamHandlerFactory> factories) {
        this((Iterable<URLStreamHandlerFactory>)factories);
    }

    public CompositeURLStreamHandlerFactory(Iterable<URLStreamHandlerFactory> factories) {
        LinkedList<URLStreamHandlerFactory> newFactories = ListUtils.newLinkedList(factories);
        this.sortFactories(newFactories);
        this.factories = newFactories;
    }

    @Override
    public final URLStreamHandler createURLStreamHandler(String protocol) {
        URLStreamHandlerFactory factory;
        URLStreamHandler handler = null;
        List<URLStreamHandlerFactory> factories = this.getFactories();
        for (int i = 0; i < factories.size() && (handler = (factory = factories.get(i)).createURLStreamHandler(protocol)) == null; ++i) {
        }
        return handler;
    }

    public CompositeURLStreamHandlerFactory addURLStreamHandlerFactory(URLStreamHandlerFactory factory) {
        if (factory != null && factory != this) {
            List<URLStreamHandlerFactory> factories = this.getFactories();
            if (factory instanceof CompositeURLStreamHandlerFactory) {
                for (URLStreamHandlerFactory element : ((CompositeURLStreamHandlerFactory)factory).getFactories()) {
                    this.addURLStreamHandlerFactory(element);
                }
            } else if (!factories.contains(factory)) {
                factories.add(factory);
            }
            this.sortFactories(factories);
        }
        return this;
    }

    protected List<URLStreamHandlerFactory> getFactories() {
        return this.factories;
    }

    protected Comparator<? super URLStreamHandlerFactory> getComparator() {
        return Prioritized.COMPARATOR;
    }

    private void sortFactories(List<URLStreamHandlerFactory> factories) {
        Collections.sort(factories, this.getComparator());
    }

    public String toString() {
        return "CompositeURLStreamHandlerFactory{factories=" + this.factories + '}';
    }
}

