/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.net;

import io.microsphere.collection.SetUtils;
import io.microsphere.lang.Prioritized;
import io.microsphere.net.SubProtocolURLConnectionFactory;
import io.microsphere.net.URLUtils;
import io.microsphere.text.FormatUtils;
import io.microsphere.util.StringUtils;
import java.io.IOException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

public abstract class ExtendableProtocolURLStreamHandler
extends URLStreamHandler {
    private final String protocol;
    private final List<SubProtocolURLConnectionFactory> factories = new ArrayList<SubProtocolURLConnectionFactory>();

    public ExtendableProtocolURLStreamHandler() {
        Class<?> currentClass = this.getClass();
        ExtendableProtocolURLStreamHandler.assertConventions(currentClass);
        String packageName = ExtendableProtocolURLStreamHandler.appendHandlerPackage(currentClass);
        this.protocol = ExtendableProtocolURLStreamHandler.resolveConventionProtocol(packageName);
    }

    public ExtendableProtocolURLStreamHandler(String protocol) {
        this.protocol = protocol;
    }

    public static Set<String> getHandlePackages() {
        String value = ExtendableProtocolURLStreamHandler.getHandlePackagesPropertyValue();
        String[] packages = StringUtils.split(value, '|');
        return SetUtils.ofSet(packages);
    }

    public static String getHandlePackagesPropertyValue() {
        return System.getProperty("java.protocol.handler.pkgs");
    }

    public void init() {
        this.initSubProtocolURLConnectionFactories();
        URLUtils.registerURLStreamHandler(this);
    }

    private void initSubProtocolURLConnectionFactories() {
        List<SubProtocolURLConnectionFactory> factories = this.factories;
        this.initSubProtocolURLConnectionFactories(factories);
        Collections.sort(factories, Prioritized.COMPARATOR);
    }

    protected void initSubProtocolURLConnectionFactories(List<SubProtocolURLConnectionFactory> factories) {
    }

    public void customizeSubProtocolURLConnectionFactories(Consumer<List<SubProtocolURLConnectionFactory>> factoriesCustomizer) {
        factoriesCustomizer.accept(this.factories);
    }

    @Override
    protected final URLConnection openConnection(URL u) throws IOException {
        return this.openConnection(u, Proxy.NO_PROXY);
    }

    @Override
    public URLConnection openConnection(URL u, Proxy p) throws IOException {
        SubProtocolURLConnectionFactory factory;
        List<String> subProtocols = this.resolveSubProtocols(u);
        URLConnection urlConnection = null;
        int size = this.factories.size();
        for (int i = 0; !(i >= size || (factory = this.factories.get(i)).supports(u, subProtocols) && (urlConnection = factory.create(u, subProtocols, p)) != null); ++i) {
        }
        return urlConnection == null ? this.openFallbackConnection(u, p) : urlConnection;
    }

    protected URLConnection openFallbackConnection(URL url, Proxy proxy) throws IOException {
        return null;
    }

    @Override
    protected final boolean equals(URL u1, URL u2) {
        return Objects.equals(this.toExternalForm(u1), this.toExternalForm(u2));
    }

    @Override
    protected final int hashCode(URL u) {
        return this.toExternalForm(u).hashCode();
    }

    @Override
    protected final boolean hostsEqual(URL u1, URL u2) {
        return Objects.equals(u1.getHost(), u2.getHost());
    }

    @Override
    protected final String toExternalForm(URL u) {
        return URLUtils.toExternalForm(u);
    }

    @Override
    protected final void parseURL(URL u, String spec, int start, int limit) {
        int end = spec.indexOf("://", start);
        if (end > start) {
            String actualSpec = this.reformSpec(u, spec, start, end, limit);
            super.parseURL(u, actualSpec, start, actualSpec.length());
        } else {
            super.parseURL(u, spec, start, limit);
        }
    }

    protected String reformSpec(URL url, String spec, int start, int end, int limit) {
        String protocol = url.getProtocol();
        String subProtocol = spec.substring(start, end);
        String[] subProtocols = StringUtils.split(subProtocol, ':');
        String matrix = URLUtils.buildMatrixString("_sp", subProtocols);
        String suffix = spec.substring(end, limit);
        int capacity = protocol.length() + matrix.length() + suffix.length();
        StringBuilder newSpecBuilder = new StringBuilder(capacity);
        newSpecBuilder.append(protocol).append(suffix);
        int insertIndex = newSpecBuilder.indexOf("?", end);
        if (insertIndex > end) {
            newSpecBuilder.insert(insertIndex, matrix);
        } else {
            newSpecBuilder.append(matrix);
        }
        return newSpecBuilder.toString();
    }

    protected List<String> resolveSubProtocols(URL url) {
        return URLUtils.resolveSubProtocols(url);
    }

    protected String resolveAuthority(URL url) {
        return URLUtils.resolveAuthority(url);
    }

    protected String resolvePath(URL url) {
        return URLUtils.resolvePath(url);
    }

    public final String getProtocol() {
        return this.protocol;
    }

    public String toString() {
        return FormatUtils.format("{} {defaultPort = {} , protocol = '{}'}", this.getClass().getName(), this.getDefaultPort(), this.getProtocol());
    }

    private static String resolveConventionProtocol(String packageName) {
        int lastIndex = packageName.lastIndexOf(46);
        return packageName.substring(lastIndex + 1);
    }

    private static void assertConventions(Class<?> type) {
        ExtendableProtocolURLStreamHandler.assertClassTopLevel(type);
        ExtendableProtocolURLStreamHandler.assertClassName(type);
        ExtendableProtocolURLStreamHandler.assertPackage(type);
    }

    static void assertClassTopLevel(Class<?> type) {
        if (type.isLocalClass() || type.isAnonymousClass() || type.isMemberClass()) {
            throw new IllegalArgumentException("The implementation " + type + " must be the top level");
        }
    }

    static void assertClassName(Class<?> type) {
        String simpleClassName = type.getSimpleName();
        if (!"Handler".equals(simpleClassName)) {
            throw new IllegalArgumentException("The implementation class must name 'Handler', actual : '" + simpleClassName + "'");
        }
    }

    static void assertPackage(Class<?> type) {
        String className = type.getName();
        if (className.indexOf(46) < 0) {
            throw new IllegalArgumentException("The Handler class must not be present at the top package!");
        }
        String packagePrefix = "sun.net.www.protocol";
        if (className.startsWith(packagePrefix)) {
            throw new IllegalArgumentException("The Handler class must not be present in the builtin package : '" + packagePrefix + "'");
        }
    }

    private static String appendHandlerPackage(Class<?> type) {
        String packageName = type.getPackage().getName();
        ExtendableProtocolURLStreamHandler.appendHandlePackage(packageName);
        return packageName;
    }

    static void appendHandlePackage(String packageName) {
        String handlePackage = packageName.substring(0, packageName.lastIndexOf(46));
        Set<String> packages = ExtendableProtocolURLStreamHandler.getHandlePackages();
        if (packages.contains(handlePackage)) {
            return;
        }
        String currentHandlerPackages = ExtendableProtocolURLStreamHandler.getHandlePackagesPropertyValue();
        String handlePackages = null;
        handlePackages = StringUtils.isBlank(currentHandlerPackages) ? handlePackage : currentHandlerPackages + '|' + handlePackage;
        System.setProperty("java.protocol.handler.pkgs", handlePackages);
    }
}

