/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.process;

import io.microsphere.annotation.Nonnull;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class ProcessManager {
    public static final ProcessManager INSTANCE = new ProcessManager();
    private final ConcurrentMap<Process, String> unfinishedProcessesCache = new ConcurrentHashMap<Process, String>();

    protected ProcessManager addUnfinishedProcess(Process process, String arguments) {
        this.unfinishedProcessesCache.putIfAbsent(process, arguments);
        return this;
    }

    protected ProcessManager removeUnfinishedProcess(Process process, String arguments) {
        this.unfinishedProcessesCache.remove(process, arguments);
        return this;
    }

    public void destroy(Process process) {
        process.destroy();
    }

    @Nonnull
    public Map<Process, String> unfinishedProcessesMap() {
        return Collections.unmodifiableMap(this.unfinishedProcessesCache);
    }
}

