/*
 * Decompiled with CFR 0.152.
 */
package io.microsphere.process;

import io.microsphere.logging.Logger;
import io.microsphere.logging.LoggerFactory;
import io.microsphere.management.JmxUtils;
import io.microsphere.process.ProcessIdResolver;
import io.microsphere.reflect.FieldUtils;
import io.microsphere.reflect.MethodUtils;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Field;

public class VirtualMachineProcessIdResolver
implements ProcessIdResolver {
    private static final Logger logger = LoggerFactory.getLogger(VirtualMachineProcessIdResolver.class);
    static final String JVM_FIELD_NAME = "jvm";
    static final String GET_PROCESS_ID_METHOD_NAME = "getProcessId";
    static final Field JVM_FIELD = FieldUtils.findField(JmxUtils.getRuntimeMXBean(), "jvm");

    @Override
    public boolean supports() {
        return JVM_FIELD != null;
    }

    @Override
    public Long current() {
        RuntimeMXBean runtimeMXBean = JmxUtils.getRuntimeMXBean();
        Object jvm = FieldUtils.getFieldValue((Object)runtimeMXBean, JVM_FIELD);
        Integer processId = (Integer)MethodUtils.invokeMethod(jvm, GET_PROCESS_ID_METHOD_NAME, new Object[0]);
        if (logger.isTraceEnabled()) {
            logger.trace("The PID was resolved from the native method 'sun.management.VMManagementImpl#getProcessId()' : {}", processId);
        }
        return processId.longValue();
    }

    @Override
    public int getPriority() {
        return 5;
    }
}

